/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.mapa.generadores;

import es.pyronixstudio.base.juego.ITickable;
import es.pyronixstudio.base.juego.mapa.MarcadorConfiguracion;
import es.pyronixstudio.base.juego.mapa.generadores.condiciones.Condicion;
import es.pyronixstudio.base.juego.mapa.generadores.generado.IGenerado;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.base.util.Ubicacion;
import es.pyronixstudio.util.RandomUtil;
import es.pyronixstudio.util.ficheros.Elemento;
import es.pyronixstudio.util.ficheros.Valor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Location;

public abstract class Generador
implements ITickable {
    protected final AbstractPartida<?, ?, ?> partida;
    private final List<UbicacionTickeable> ubicaciones;
    private final Map<UbicacionTickeable, IGenerado> cosasGeneradas = new HashMap<UbicacionTickeable, IGenerado>();
    private final Set<IGenerado> historialGenerado = new HashSet<IGenerado>();
    private final Elemento elementoConfig;
    protected final boolean random;
    protected final boolean tickLocal;
    private final Condicion condicion;
    private int ticks = 0;
    private final int ticksEsperar;

    public Generador(MarcadorConfiguracion marcadorConfig, AbstractPartida<?, ?, ?> partida) {
        this.partida = partida;
        this.elementoConfig = marcadorConfig.config;
        this.ticksEsperar = this.elementoConfig.get("ticks").asInt(20);
        int alturaRelativa = this.elementoConfig.get("alturaRelativa").asInt(0);
        this.random = !this.elementoConfig.get("desactivarRandom").asBoolean();
        this.tickLocal = this.elementoConfig.getOrDefault("tickLocal", (Object)false).asBoolean();
        this.ubicaciones = marcadorConfig.getUbicaciones().stream().map(ubicacion -> UbicacionTickeable.of(ubicacion.add(0.5, (double)alturaRelativa, 0.5), this.ticksEsperar, this.tickLocal)).collect(Collectors.toCollection(ArrayList::new));
        this.condicion = (Condicion)RegistrosBase.CONDICIONES_GENERADORES.get(this.elementoConfig.get("condicion")).crear();
    }

    protected Map<String, Valor> getElementosAGenerar() {
        return this.elementoConfig.get("generar").asMap();
    }

    public void reset() {
        this.historialGenerado.forEach(IGenerado::reset);
        this.historialGenerado.clear();
        this.cosasGeneradas.clear();
    }

    private UbicacionTickeable getRandomLocation() {
        return (UbicacionTickeable)RandomUtil.getRandomFromList(this.ubicaciones);
    }

    protected abstract void procesarPreTick();

    protected abstract void procesarTick();

    protected abstract IGenerado generar(UbicacionTickeable var1);

    private void preGenerar(UbicacionTickeable location) {
        IGenerado generado;
        location.tick();
        if (location.canGenerate() && (generado = this.generar(location)) != null) {
            if (this.condicion != null) {
                this.ubicaciones.remove(location);
                this.cosasGeneradas.put(location, generado);
            }
            this.historialGenerado.add(generado);
        }
    }

    private void ejecutarCondicionALocation(UbicacionTickeable location) {
        if (this.condicion == null) {
            return;
        }
        IGenerado generado = this.cosasGeneradas.get(location);
        if (generado == null) {
            return;
        }
        boolean pasaCondicion = this.condicion.test(generado);
        if (pasaCondicion) {
            this.cosasGeneradas.remove(location);
            this.ubicaciones.add(location);
        }
    }

    public void preTick() {
        if (!this.tickLocal) {
            ++this.ticks;
            if (this.ticks < this.ticksEsperar) {
                return;
            }
        }
        if (!this.cosasGeneradas.isEmpty()) {
            ArrayList<UbicacionTickeable> generada = new ArrayList<UbicacionTickeable>(this.cosasGeneradas.keySet());
            generada.forEach(this::ejecutarCondicionALocation);
        }
        this.procesarPreTick();
    }

    @Override
    public void tick() {
        if (!this.tickLocal && this.ticks < this.ticksEsperar) {
            return;
        }
        if (this.random) {
            UbicacionTickeable randomLocation = this.getRandomLocation();
            if (randomLocation != null) {
                this.preGenerar(randomLocation);
            }
        } else {
            List<UbicacionTickeable> ubicacionesCopia = List.copyOf(this.ubicaciones);
            ubicacionesCopia.forEach(this::preGenerar);
        }
        this.procesarTick();
        this.ticks = 0;
    }

    protected static final class UbicacionTickeable
    extends Ubicacion.BlockLocation
    implements ITickable {
        private int ticks = 0;
        private final int ticksEsperar;
        private boolean generar = false;

        protected static UbicacionTickeable of(Location bukkitLocation, int ticksEsperar, boolean tickLocal) {
            return new UbicacionTickeable(bukkitLocation, tickLocal ? ticksEsperar : -1);
        }

        public UbicacionTickeable(Location bukkitLocation, int ticksEsperar) {
            super(bukkitLocation);
            this.ticksEsperar = ticksEsperar;
        }

        @Override
        public void tick() {
            if (this.ticksEsperar == -1) {
                this.generar = true;
                return;
            }
            ++this.ticks;
            if (this.ticks < this.ticksEsperar) {
                this.generar = false;
                return;
            }
            this.ticks = 0;
            this.generar = true;
        }

        public boolean canGenerate() {
            return this.generar;
        }

        public String toString() {
            return String.format("Ticks A Esperar:%s, Tick Actual:%s, Generar:%s", this.ticksEsperar, this.ticks, this.generar);
        }
    }
}

