/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.core;

import es.pyronixstudio.base.core.EnumPluginState;
import es.pyronixstudio.base.core.PluginStateEvent;
import es.pyronixstudio.base.core.RutasBase;
import es.pyronixstudio.base.juego.entidades.EntityEventManager;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.PartidaManager;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.util.Logger;
import java.util.List;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class PyronixPlugin<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
extends JavaPlugin {
    public static PyronixPlugin<?, ?, ?> INSTANCE;
    public final PartidaManager<J, E, P> partidaManager;
    public final EnumPluginState pluginState;

    public PyronixPlugin(boolean multiPartida, EnumPluginState pluginState) {
        if (INSTANCE == null) {
            INSTANCE = this;
        }
        this.partidaManager = new PartidaManager(this, multiPartida);
        this.pluginState = pluginState;
        Logger.setLogger((Logger.LoggerResolver)new Logger.LoggerResolver(this.getLogger()));
    }

    public PyronixPlugin(boolean multiPartida) {
        this(multiPartida, EnumPluginState.RELEASE);
    }

    public abstract Supplier<P> getPartidaSupplier();

    protected RegistrosBase invocarRegistros() {
        return new RegistrosBase();
    }

    protected void alCargar() {
    }

    protected void alActivarse() {
    }

    protected void alDesactivarse() {
    }

    public abstract String identificadorPlugin();

    public static NamespacedKey generateKey(String key) {
        return NamespacedKey.fromString((String)key, INSTANCE);
    }

    public String nombrePluginFormato() {
        return String.format("<gray>[<red>%s<gray>] ", this.identificadorPlugin());
    }

    public static void registrarEventos(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, INSTANCE);
    }

    public static void desregistrarEventos(Listener listener) {
        HandlerList.unregisterAll((Listener)listener);
    }

    public final void onLoad() {
        this.alCargar();
        this.getLogger().info("Cargado con exito!");
    }

    public final void onEnable() {
        this.alActivarse();
        this.getLogger().info("Activado con exito!");
        if (RutasBase.PLUGIN_CARPETA.toFile().mkdirs()) {
            this.alCrearCarpetaConfiguracion();
        }
        this.invocarRegistros();
        PyronixPlugin.registrarEventos(new EntityEventManager());
        if (!this.pluginState.equals((Object)EnumPluginState.RELEASE)) {
            PyronixPlugin.registrarEventos(new PluginStateEvent(this.pluginState));
        }
    }

    public final void onDisable() {
        this.alDesactivarse();
        this.getLogger().info("Desactivado con exito!");
    }

    public abstract void alCrearCarpetaConfiguracion();

    public static Component format(String texto, boolean conNombre) {
        return MiniMessage.miniMessage().deserialize((Object)(conNombre ? PyronixPlugin.formatString(texto) : texto));
    }

    public static Component format(String texto) {
        return PyronixPlugin.format(texto, true);
    }

    public static Component format(String texto, Component ... components) {
        return PyronixPlugin.format(texto, true, components);
    }

    public static Component format(String texto, boolean conNombre, String ... textos) {
        List<String> textosList = List.of(textos);
        return PyronixPlugin.format(texto, conNombre, textosList.stream().map(cadena -> PyronixPlugin.format(cadena, conNombre)).toList().toArray(new Component[textos.length]));
    }

    public static Component format(String texto, boolean conNombre, Component ... components) {
        Component componente = PyronixPlugin.format(texto, conNombre);
        for (Component component : components) {
            componente = componente.append(component);
        }
        return componente;
    }

    protected static String formatString(String texto) {
        return String.format("%s%s", INSTANCE.nombrePluginFormato(), texto);
    }
}

