/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base;

import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.util.serializable.PyronixBuff;
import es.pyronixstudio.util.serializable.codecs.ByteObjectCodec;
import es.pyronixstudio.util.serializable.codecs.CodecHelper;
import es.pyronixstudio.util.serializable.codecs.Codecs;
import es.pyronixstudio.util.wrapper.Wrapper;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemStackSerializable {
    public static final ByteObjectCodec<ItemStackSerializable> CODEC = CodecHelper.create((buff, obj) -> buff.writeBytes(obj.serializado), buff -> null);
    private ItemStack stack;
    private final byte[] serializado;

    public ItemStackSerializable(Builder builder, byte[] serializado) {
        this.stack = builder.stack;
        this.serializado = serializado;
    }

    public ItemStack getVanillaStack() {
        return this.stack;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("[ItemStackSerializable stack=%s]", this.stack.toString());
    }

    public static class Builder {
        public static ByteObjectCodec<Builder> CODEC = CodecHelper.composite((ByteObjectCodec)Codecs.STRING_CODEC, obj -> obj.stack.getType().name().toLowerCase(), (ByteObjectCodec)Codecs.INT_CODEC, obj -> obj.stack.getAmount(), (ByteObjectCodec)Codecs.ofWrapper((ByteObjectCodec)Codecs.INT_CODEC), obj -> obj.customModelData, (ByteObjectCodec)Codecs.ofWrapper((ByteObjectCodec)Codecs.STRING_CODEC), obj -> obj.nombre, (ByteObjectCodec)Codecs.ofList((ByteObjectCodec)Codecs.STRING_CODEC), obj -> obj.lores, (ByteObjectCodec)Codecs.ofHashMap((ByteObjectCodec)Codecs.STRING_CODEC, (ByteObjectCodec)Codecs.INT_CODEC), obj -> obj.enchatments, null);
        private ItemStack stack;
        private ItemMeta meta;
        private List<String> lores = new ArrayList<String>();
        private Wrapper<String> nombre = Wrapper.empty();
        private Map<String, Integer> enchatments = new HashMap<String, Integer>();
        private Wrapper<Integer> customModelData = Wrapper.empty();

        public Builder() {
            this.stack = new ItemStack(Material.BARRIER);
            this.meta = this.stack.getItemMeta();
        }

        public Builder(Builder oldBuilder) {
            this.stack = oldBuilder.stack.clone();
            this.nombre = Wrapper.of((Object)((String)oldBuilder.nombre.get()));
            this.customModelData = Wrapper.of((Object)((Integer)oldBuilder.customModelData.get()));
            this.meta = oldBuilder.meta.clone();
            this.lores = new ArrayList<String>(oldBuilder.lores);
            this.enchatments = new HashMap<String, Integer>(this.enchatments);
        }

        public Builder setCustomName(String name) {
            this.nombre.set((Object)String.format("<reset>%s", name));
            this.meta.displayName(PyronixPlugin.format((String)this.nombre.get(), false).decoration(TextDecoration.ITALIC, false));
            return this;
        }

        public Builder addLore(String loreSinFormato) {
            ArrayList<Component> lores = this.meta.lore();
            if (lores == null) {
                lores = new ArrayList<Component>();
            }
            String lore = String.format("<reset>%s", loreSinFormato);
            lores.add(PyronixPlugin.format(lore, false).decoration(TextDecoration.ITALIC, false));
            this.lores.add(lore);
            this.setLores(lores);
            return this;
        }

        private Builder setLores(List<Component> lores) {
            this.meta.lore(lores);
            return this;
        }

        public Builder addEnchanment(Enchantment enchantment, int level) {
            String nombreEncantamiento = enchantment.getKey().getKey();
            this.enchatments.put(nombreEncantamiento, level);
            this.meta.addEnchant(enchantment, level, true);
            return this;
        }

        public Builder addEnchanment(String idEncantamiento, int level) {
            return this.addEnchanment((Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(NamespacedKey.minecraft((String)idEncantamiento.toLowerCase())), level);
        }

        public Builder setCustomModelData(int modelData) {
            this.meta.setCustomModelData(Integer.valueOf(modelData));
            this.customModelData.set((Object)modelData);
            return this;
        }

        public Builder setType(Material type) {
            this.stack = this.stack.withType(type);
            return this;
        }

        public Builder setAmount(int amount) {
            this.stack.setAmount(amount);
            return this;
        }

        public ItemStackSerializable build() {
            this.stack.setItemMeta(this.meta);
            PyronixBuff buff = PyronixBuff.empty();
            buff.writeObject(CODEC, (Object)this);
            return new ItemStackSerializable(this, buff.toByteArray());
        }

        public Builder clone() {
            return new Builder(this);
        }
    }
}

