/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.util;

import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class ItemStackUtil {
    public static <P, C> C getDataFromItemStack(ItemStack stack, NamespacedKey nameSpace, PersistentDataType<P, C> type) {
        PersistentDataContainer nbt = ItemStackUtil.getDataContainer(stack.getItemMeta());
        if (nbt == null) {
            return null;
        }
        return (C)nbt.get(nameSpace, type);
    }

    public static <P, C> void setDataToItemStack(ItemStack stack, NamespacedKey nameSpace, PersistentDataType<P, C> type, C data) {
        ItemMeta meta = stack.getItemMeta();
        PersistentDataContainer nbt = ItemStackUtil.getDataContainer(meta);
        if (nbt == null) {
            return;
        }
        nbt.set(nameSpace, type, data);
        stack.setItemMeta(meta);
    }

    public static <P, C> void setDataToItemStack(ItemMeta meta, NamespacedKey nameSpace, PersistentDataType<P, C> type, C data) {
        PersistentDataContainer nbt = ItemStackUtil.getDataContainer(meta);
        if (nbt == null) {
            return;
        }
        nbt.set(nameSpace, type, data);
    }

    public static PersistentDataContainer getDataContainer(ItemMeta meta) {
        if (meta == null) {
            return null;
        }
        PersistentDataContainer nbtContainer = meta.getPersistentDataContainer();
        if (nbtContainer == null) {
            return null;
        }
        return nbtContainer;
    }
}

