/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.sonido;

import es.pyronixstudio.base.juego.partida.jugador.JugadorManager;
import es.pyronixstudio.base.registros.tipo.IRegistro;
import es.pyronixstudio.base.sonido.SonidoBase;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SonidoManager {
    public static void reproducirAudioATodos(IRegistro<SonidoBase> sonido, float volumen, float pitch) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            SonidoManager.reproducirSonidoAJugador(player, sonido, volumen, pitch);
        }
    }

    public static void reproducirAudioEnJugadorYUbicacion(UUID uuid, IRegistro<SonidoBase> sonido, int volumen, int pitch) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null && player.isOnline()) {
            player.playSound(player.getLocation(), sonido.crear().identificador, SoundCategory.VOICE, (float)volumen, (float)pitch);
        }
    }

    public static void reproducirAudioATodosEnPartida(JugadorManager<?, ?, ?> jugadorManager, IRegistro<SonidoBase> sonido, float volumen, float pitch) {
        SonidoManager.reproducirSonidoAJugadores(sonido, volumen, pitch, jugadorManager.getAllUUID());
    }

    public static void cancelarAudios(Collection<UUID> jugadores, IRegistro<SonidoBase> supplierSonido) {
        SonidoBase audio = supplierSonido.crear();
        for (UUID uuid : jugadores) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || !player.isOnline()) continue;
            for (SoundCategory categoria : SoundCategory.values()) {
                player.stopSound(audio.identificador, categoria);
            }
        }
    }

    public static void reproducirAudioEnMundo(Location location, IRegistro<SonidoBase> sonido, float volumen, float pitch) {
        SonidoManager.reproducirAudioEnMundo(location, sonido, SoundCategory.MASTER, volumen, pitch);
    }

    public static void reproducirAudioEnMundo(Location location, IRegistro<SonidoBase> sonido, SoundCategory categoria, float volumen, float pitch) {
        World world = location.getWorld();
        world.playSound(location, sonido.crear().identificador, categoria, volumen, pitch);
    }

    public static void reproducirSonidoAJugadores(IRegistro<SonidoBase> supplierSonido, float volumen, float pitch, Collection<UUID> uuids) {
        SonidoBase sonido = supplierSonido.crear();
        uuids.forEach(uuid -> SonidoManager.reproducirSonidoAJugador(Bukkit.getPlayer((UUID)uuid), sonido, volumen, pitch));
    }

    public static void reproducirSonidoAJugador(Player player, SonidoBase sonido, float volumen, float pitch) {
        if (player != null && player.isOnline()) {
            player.playSound((Entity)player, sonido.identificador, SoundCategory.MASTER, volumen, pitch);
        }
    }

    public static void reproducirSonidoAJugador(Player player, IRegistro<SonidoBase> sonido, float volumen, float pitch) {
        if (player != null && player.isOnline()) {
            player.playSound((Entity)player, sonido.crear().identificador, SoundCategory.MASTER, volumen, pitch);
        }
    }
}

