/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.registros.tipo;

import es.pyronixstudio.base.registros.tipo.IRegistro;
import es.pyronixstudio.util.RandomUtil;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class RegistroPesosRandom<T>
implements IRegistro<T> {
    private final NavigableMap<Integer, IRegistro<T>> mapaPesos = new TreeMap<Integer, IRegistro<T>>();
    private int pesoTotal = 0;

    public static <T> IRegistro<T> of(Map<IRegistro<T>, Integer> registrosPesos) {
        return new RegistroPesosRandom<T>(registrosPesos);
    }

    private RegistroPesosRandom(Map<IRegistro<T>, Integer> registrosPesos) {
        for (Map.Entry<IRegistro<T>, Integer> parejaPeso : registrosPesos.entrySet()) {
            IRegistro<T> registro;
            int porcentaje = parejaPeso.getValue();
            if (porcentaje <= 0 || (registro = parejaPeso.getKey()).isEmpty()) continue;
            this.pesoTotal += porcentaje;
            this.mapaPesos.put(this.pesoTotal, registro);
        }
    }

    public T get() {
        int dado = RandomUtil.getRandom((int)0, (int)this.pesoTotal);
        Map.Entry<Integer, IRegistro<T>> registroRandom = this.mapaPesos.ceilingEntry(dado);
        if (registroRandom == null) {
            return null;
        }
        return registroRandom.getValue().crear();
    }

    public boolean isEmpty() {
        return this.mapaPesos.isEmpty();
    }
}

