/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.mapa.serializador;

import java.util.List;
import org.bukkit.block.data.BlockData;

public interface IBloqueHandler<T extends BlockData> {
    default public void deserializarSeguro(BlockData data, String[] parametros) {
        BlockData dataCasted = (BlockData)this.getTargetClass().cast(data);
        this.deserializar(dataCasted, parametros);
    }

    default public void serializarSeguro(BlockData data, List<Object> builder) {
        T dataCasted = this.castIfInstance(data);
        if (dataCasted != null) {
            this.serializar(dataCasted, builder);
        }
    }

    private T castIfInstance(BlockData data) {
        Class<T> clase = this.getTargetClass();
        if (clase.isInstance(data)) {
            return (T)((BlockData)clase.cast(data));
        }
        return null;
    }

    default public boolean isInstance(BlockData data) {
        return this.getTargetClass().isInstance(data);
    }

    public void serializar(T var1, List<Object> var2);

    public void deserializar(T var1, String[] var2);

    public Class<T> getTargetClass();

    default public int getParametersNumber() {
        return 1;
    }
}

