/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.items;

import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.juego.items.Accion;
import es.pyronixstudio.base.juego.items.ItemPersonalizadoLanzable;
import es.pyronixstudio.base.registros.RegistradorNameSpaceBase;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.base.util.ItemStackUtil;
import es.pyronixstudio.util.ficheros.Elemento;
import es.pyronixstudio.util.ficheros.Valor;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemAttributeModifiers;
import java.util.function.Function;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class ItemPersonalizado
implements Cloneable {
    public final int maxStack;
    private int cantidad = 0;
    protected final Material material;
    protected final int customModelData;
    private final ItemStack stack;
    public final String id;
    private final String idAccion;
    public final Elemento args;
    private Accion<?, ?, ?> accion;

    public static ItemPersonalizado of(Elemento config) {
        Valor tipo = config.getOrDefault("tipo", (Object)EnumTipo.NINGUNO);
        return switch (((EnumTipo)tipo.asEnum(EnumTipo.class)).ordinal()) {
            case 1 -> ItemPersonalizado.of(config, ItemPersonalizadoLanzable::new);
            default -> ItemPersonalizado.of(config, ItemPersonalizado::new);
        };
    }

    public static <T extends ItemPersonalizado> T of(Elemento config, Function<Elemento, T> factory) {
        return (T)((ItemPersonalizado)factory.apply(config));
    }

    protected ItemPersonalizado(Elemento config) {
        this.id = config.id;
        this.material = (Material)config.get("material").asEnum(Material.class);
        this.customModelData = config.get("customModelData").asInt();
        this.maxStack = config.get("maxStack").asInt();
        this.stack = new ItemStack(this.material);
        ItemMeta meta = this.stack.getItemMeta();
        meta.setCustomModelData(Integer.valueOf(this.customModelData));
        meta.displayName(PyronixPlugin.format(config.get("titulo").asString(), false).decoration(TextDecoration.ITALIC, false));
        this.setDatosContainer(meta, this.id);
        this.stack.setItemMeta(meta);
        this.stack.setData(DataComponentTypes.MAX_STACK_SIZE, (Object)this.maxStack);
        this.stack.setData(DataComponentTypes.ATTRIBUTE_MODIFIERS, (DataComponentBuilder)ItemAttributeModifiers.itemAttributes().addModifier(Attribute.ENTITY_INTERACTION_RANGE, new AttributeModifier(PyronixPlugin.generateKey("interaction_entity"), -10.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.MAINHAND)));
        this.args = config.get("argsAccion").asUnmodifiableElemento();
        this.idAccion = config.get("accion").asString();
        this.asignarAccion();
    }

    protected void asignarAccion() {
        this.accion = (Accion)RegistrosBase.ACCIONES.get(this.idAccion).crear();
        this.accion.init(this.args);
    }

    public Accion<?, ?, ?> getAccion() {
        return this.accion;
    }

    protected void setDatosContainer(ItemMeta meta, String id) {
        ItemStackUtil.setDataToItemStack(meta, RegistradorNameSpaceBase.ITEM_PERSONALIZADO_NAME_SPACE, PersistentDataType.STRING, id);
    }

    public ItemStack getItemStack() {
        return this.stack.clone();
    }

    public void setCantidad(int cantidad) {
        this.cantidad = cantidad;
    }

    public void sumarCantidad(int cantidad) {
        this.setCantidad(this.getCantidad() + cantidad);
    }

    public boolean restarCantidad(int cantidad) {
        int nuevaCantidad = this.cantidad - cantidad;
        if (nuevaCantidad < 0) {
            nuevaCantidad = 0;
        }
        this.setCantidad(nuevaCantidad);
        return nuevaCantidad == 0;
    }

    public int getCantidad() {
        return this.cantidad;
    }

    public String toString() {
        return String.format("maxStack:%s, materia:%s, customModelData:%s args:%s, accion%s, stack:%s", this.maxStack, this.material, this.customModelData, this.args, this.accion.getClass().getSimpleName(), this.stack.toString());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ItemPersonalizado) {
            ItemPersonalizado otroItem = (ItemPersonalizado)obj;
            return otroItem.id.equals(this.id);
        }
        return false;
    }

    public ItemPersonalizado clone() {
        try {
            ItemPersonalizado itemClonado = (ItemPersonalizado)super.clone();
            itemClonado.asignarAccion();
            return itemClonado;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static enum EnumTipo {
        USABLE,
        LANZABLE,
        NINGUNO;

    }
}

