/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.items;

import es.pyronixstudio.base.core.PyronixScheduler;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.items.EstadoEjecuccion;
import es.pyronixstudio.base.juego.items.contextos.ItemDamagePlayerContext;
import es.pyronixstudio.base.juego.items.contextos.ItemExecutionContext;
import es.pyronixstudio.base.juego.items.contextos.ItemHitContext;
import es.pyronixstudio.base.juego.items.contextos.ItemLaunchContext;
import es.pyronixstudio.base.juego.items.contextos.ItemUseContext;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.util.EnumUtil;
import es.pyronixstudio.util.ficheros.Elemento;
import es.pyronixstudio.util.ficheros.Valor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public abstract class Accion<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>> {
    protected Elemento args;
    protected List<Material> materialExtras;
    protected boolean inCooldown = false;
    private int cooldown = 0;

    public final void init(Elemento args) {
        this.args = args;
        this.cooldown = args.getOrDefault("cooldown", (Object)0).asInt();
        Valor materialesIds = args.get("materialExtras");
        if (materialesIds != null) {
            this.materialExtras = materialesIds.asStringList().stream().map(id -> (Material)EnumUtil.valueOfSecure(Material.class, (String)id)).collect(Collectors.toCollection(ArrayList::new));
        }
        this.onInit();
    }

    protected abstract void onInit();

    public void onHit(ItemHitContext<J, E, P> contexto) {
    }

    public final void testCooldown(ItemExecutionContext<J, E, P> contexto) {
        EstadoEjecuccion estado = contexto.estadoEjecuccion;
        if (estado.isNoProcesar()) {
            return;
        }
        if (contexto.hasCooldown()) {
            if (this.inCooldown) {
                estado.setNoProcesar();
                return;
            }
            this.inCooldown = true;
            PyronixScheduler.runTaskLater(this.cooldown, task -> {
                this.inCooldown = false;
            });
        }
        this.onCooldownTestSuccess(contexto);
    }

    public abstract void onCooldownTestSuccess(ItemExecutionContext<J, E, P> var1);

    public void onPreCooldownTest(ItemExecutionContext<J, E, P> contexto) {
    }

    public void setProjectileProperties(ItemLaunchContext<J, E, P> contexto) {
    }

    public void onLaunch(ItemLaunchContext<J, E, P> contexto) {
    }

    public void onUse(ItemUseContext<J, E, P> contexto) {
    }

    public void onDamagePlayer(ItemDamagePlayerContext<J, E, P> contexto) {
    }

    public void onItemAddedToInventory(Player player) {
        if (this.materialExtras == null) {
            return;
        }
        if (player == null) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        for (int i = 0; i < this.materialExtras.size(); ++i) {
            Material material = this.materialExtras.get(i);
            inventory.setItem(9 + i, new ItemStack(material));
        }
    }
}

