/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.equipo;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.meta.trim.TrimPattern;

public enum EnumColor {
    AZUL_CLARO("light_blue", TrimPattern.EYE, 3858943),
    AZUL("blue", TrimPattern.DUNE, 9471),
    CIAN("cyan", TrimPattern.RAISER, 2343318),
    LIMA("lime", TrimPattern.SHAPER, 65280),
    VERDE("green", TrimPattern.WAYFINDER, 100609),
    ROJO("red", TrimPattern.WARD, 15338508),
    MORADO("purple", TrimPattern.SPIRE, 7341544),
    MAGENTA("magenta", null, 0xCC00FF),
    ROSA("pink", TrimPattern.SILENCE, 16673726),
    AMARILLO("yellow", TrimPattern.COAST, 0xFFFF00),
    NARANJA("orange", TrimPattern.TIDE, 16743936),
    MARRON("brown", TrimPattern.SNOUT, 7158278),
    GRIS("gray", TrimPattern.RIB, 0x858585),
    GRIS_CLARO("light_gray", TrimPattern.SENTRY, 0xC8C8C8),
    NEGRO("black", TrimPattern.VEX, 0x141414),
    BLANCO("white", TrimPattern.HOST, 0xFFFFFF);

    public final String ingles;
    public final TrimPattern trim;
    public final int colorHex;

    private EnumColor(String ingles, TrimPattern trim, int colorHex) {
        this.ingles = ingles;
        this.trim = trim;
        this.colorHex = colorHex;
    }

    public String nameLowerCase() {
        return this.name().toLowerCase();
    }

    public String formatedName() {
        StringBuilder stringBuilder = new StringBuilder();
        String name = this.name().replace("_", " ");
        stringBuilder.append(name.substring(0, 1).toUpperCase());
        stringBuilder.append(name.substring(1, name.length()).toLowerCase());
        return stringBuilder.toString();
    }

    public String formatedColoredName() {
        return String.format("<color:#%s>%s", Integer.toHexString(this.colorHex), this.formatedName());
    }

    public static EnumColor getEnumFromEnglish(String ingles) {
        return List.of(EnumColor.values()).stream().filter(color -> color.ingles.equalsIgnoreCase(ingles)).findFirst().orElse(null);
    }

    public static EnumColor getEnumFromMaterial(Material material) {
        String[] separado = material.name().split("_");
        StringBuffer colorBuffer = new StringBuffer();
        colorBuffer.append(separado[0]);
        if (separado[0].equals("LIGHT")) {
            colorBuffer.append(String.format("_%s", separado[1]));
        }
        return EnumColor.getEnumFromEnglish(colorBuffer.toString());
    }

    public static boolean esValorEnum(String valor) {
        try {
            EnumColor.valueOf(valor);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

