/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.equipo;

import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.equipo.EnumColor;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.ResetManager;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.util.functional.function.Function3;
import java.util.function.BiFunction;
import org.bukkit.entity.Player;

public abstract class AbstractPlayerTeamFactory<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>> {
    private P partida;
    private ResetManager resetManager;

    public AbstractPlayerTeamFactory(P partida) {
        this.partida = partida;
        this.resetManager = ((AbstractPartida)partida).resetManager;
    }

    public abstract Function3<Player, E, Boolean, J> creadorJugadores();

    public J crearJugador(Player player, E equipo, boolean anunciar) {
        AbstractJugador jugadorCreado = (AbstractJugador)this.creadorJugadores().apply((Object)player, equipo, (Object)anunciar);
        this.resetManager.agregarObjeto(jugadorCreado);
        return (J)jugadorCreado;
    }

    public abstract BiFunction<EnumColor, P, E> creadorEquipos();

    public abstract void preInicializarEquipo(E var1);

    public void preInicializarBase(E equipo) {
        this.resetManager.agregarObjeto(equipo);
        this.preInicializarEquipo(equipo);
    }

    public E crearEquipo(EnumColor color) {
        AbstractEquipo equipoCreado = (AbstractEquipo)this.creadorEquipos().apply(color, this.partida);
        this.preInicializarBase(equipoCreado);
        return (E)equipoCreado;
    }
}

