/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.entidades;

import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.juego.entidades.DisplayEntity;
import es.pyronixstudio.base.juego.entidades.Transformacion;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.base.registros.tipo.IRegistro;
import es.pyronixstudio.base.util.Ubicacion;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DisplayEntityManager
extends BukkitRunnable
implements IReseteable {
    private final Map<Ubicacion.BlockLocation, DisplayEntity<Display>> entidadesPorUbicacion = new ConcurrentHashMap<Ubicacion.BlockLocation, DisplayEntity<Display>>();

    public DisplayEntityManager() {
        this.runTaskTimer((Plugin)PyronixPlugin.INSTANCE, 100L, 1L);
    }

    @Override
    public boolean reset(AbstractPartida<?, ?, ?> partida) {
        this.cancel();
        this.entidadesPorUbicacion.keySet().forEach(this::remove);
        return false;
    }

    private IRegistro<Transformacion<Display>> getTransformacion(Display display) {
        if (display instanceof BlockDisplay) {
            BlockDisplay block = (BlockDisplay)display;
            Material material = block.getBlock().getMaterial();
            return RegistrosBase.DISPLAY_TRANSFORMACIONES.get((Enum<?>)material);
        }
        return null;
    }

    public void add(Location ubicacion, Display entity) {
        this.entidadesPorUbicacion.put(Ubicacion.BlockLocation.fromBukkit(ubicacion), DisplayEntity.of(this.getTransformacion(entity), entity));
    }

    public void remove(Ubicacion.BlockLocation ubicacion) {
        DisplayEntity<Display> displayEntity = this.entidadesPorUbicacion.remove(ubicacion);
        if (displayEntity != null) {
            displayEntity.entidad.remove();
        }
    }

    public void remove(Location ubicacion) {
        this.remove(Ubicacion.BlockLocation.fromBukkit(ubicacion));
    }

    public void run() {
        this.entidadesPorUbicacion.values().forEach(displayEntity -> displayEntity.transformacion.ifPresent(transformacion -> transformacion.transformar()));
    }
}

