/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.estructuras;

import es.pyronixstudio.base.core.RutasBase;
import es.pyronixstudio.base.estructuras.Estructura;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.registros.tipo.IRegistro;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;

public class EstructuraManager
implements IReseteable {
    private Map<String, List<String>> cache = new HashMap<String, List<String>>();

    public Estructura.EstructuraGenerada generar(IRegistro<Estructura> supplier, Location ubicacion, BlockFace orientacion, Set<Material> materilesPermitidos, boolean force) {
        Estructura estrucuraAGenerar = supplier.crear();
        List<String> patron = this.buscarOMeterCache(estrucuraAGenerar.id);
        return estrucuraAGenerar.generar(patron, ubicacion, orientacion, materilesPermitidos, force);
    }

    public Estructura.EstructuraGenerada generar(IRegistro<Estructura> supplier, Location ubicacion, BlockFace orientacion, Set<Material> materilesPermitidos) {
        return this.generar(supplier, ubicacion, orientacion, materilesPermitidos, false);
    }

    public Estructura.EstructuraGenerada generar(IRegistro<Estructura> supplier, Location ubicacion, Set<Material> materilesPermitidos, boolean force) {
        return this.generar(supplier, ubicacion, BlockFace.NORTH, materilesPermitidos, force);
    }

    public Estructura.EstructuraGenerada generar(IRegistro<Estructura> supplier, Location ubicacion) {
        return this.generar(supplier, ubicacion, null, false);
    }

    private List<String> buscarOMeterCache(String id) {
        return this.cache.computeIfAbsent(id, key -> RutasBase.ESTRUCTURA_FICHERO.apply((String)key).getAllLines());
    }

    @Override
    public boolean reset(AbstractPartida<?, ?, ?> partida) {
        this.cache.clear();
        return false;
    }
}

