/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.componentes;

import es.pyronixstudio.base.componentes.Componente;
import es.pyronixstudio.base.core.PyronixScheduler;
import es.pyronixstudio.base.registros.tipo.IRegistro;
import es.pyronixstudio.util.CastUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class SistemaComponente {
    private final Map<Componente<?>, Object> componentes = new HashMap();

    public static SistemaComponente create() {
        return new SistemaComponente();
    }

    private SistemaComponente() {
    }

    public void putAll(Map<Componente<?>, Object> toAdd) {
        this.componentes.putAll(toAdd);
    }

    public Map<Componente<?>, Object> getAll() {
        return this.componentes;
    }

    private <T> void add(Componente<T> componente, T instancia) {
        this.componentes.put(componente, instancia);
    }

    public <T> void addTemporaly(IRegistro<Componente<T>> componente, T instancia, int ticks) {
        this.add(componente, instancia);
        PyronixScheduler.runTaskLater(ticks, task -> this.remove(componente));
    }

    public final <T> boolean remove(IRegistro<Componente<T>> componente) {
        Object devuelto = this.componentes.remove(componente.crear());
        return devuelto != null;
    }

    public final <T> void add(IRegistro<Componente<T>> componente, T instancia) {
        this.add(componente.crear(), instancia);
    }

    public final <T> T get(IRegistro<Componente<T>> componente) {
        return this.get(componente.crear());
    }

    public final <T, R> R getWithCast(IRegistro<Componente<T>> componente) {
        return (R)CastUtil.cast(this.get(componente));
    }

    public final <T> T get(Componente<T> componente) {
        Object objeto = this.componentes.get(componente);
        if (objeto == null) {
            return null;
        }
        return componente.clase.cast(objeto);
    }

    public final <T> T getOrDefault(IRegistro<Componente<T>> componente, T defaultObject) {
        T objeto = this.get(componente);
        return objeto == null ? defaultObject : objeto;
    }

    public final <T> void transform(IRegistro<Componente<T>> componenteSupplier, Function<T, T> funcion) {
        this.transform(componenteSupplier.crear(), funcion);
    }

    public final <T> void transform(Componente<T> componente, Function<T, T> funcion) {
        T valor = this.get(componente);
        this.add(componente, funcion.apply(valor));
    }

    public String toString() {
        return String.format("{[SistemaComponente] %s}", this.componentes);
    }
}

