/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.comandos.base;

import es.pyronixstudio.base.comandos.AbstractComandoAvanzado;
import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.core.RutasBase;
import es.pyronixstudio.base.juego.items.ItemManager;
import es.pyronixstudio.base.juego.mapa.AbstractConfiguracionMapa;
import es.pyronixstudio.base.juego.mapa.AbstractMapa;
import es.pyronixstudio.base.util.Ubicacion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class AbstractComandoMapaBase
extends AbstractComandoAvanzado {
    public abstract boolean onMapaCommandExtra(CommandSender var1, String var2, String var3, List<String> var4);

    public abstract Collection<String> onAutoCompleteMapa(CommandSender var1, String var2, String var3, String[] var4);

    public abstract AbstractConfiguracionMapa invocarConfiguracionMapa(String var1);

    public abstract AbstractMapa<?, ?, ?, ?> invocarMapa(String var1);

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (this.isCommandBlock(sender)) {
            return true;
        }
        if (!this.isOP(sender)) {
            return true;
        }
        if (args.length == 0) {
            return true;
        }
        String subComando = args[0];
        List<String> argumentos = this.quitarPrimerArgumento(args);
        this.parserSubComandos((Player)sender, subComando, label, argumentos);
        return true;
    }

    private void parserSubComandos(Player sender, String subComando, String label, List<String> args) {
        if (this.onMapaCommandExtra((CommandSender)sender, subComando, label, args)) {
            return;
        }
        if (args.size() == 0) {
            this.enviarMensaje("Necesitas especificar el nombre del mapa.", (CommandSender)sender);
            return;
        }
        String nomreMapa = args.get(0);
        if (subComando.equals("crear")) {
            if (AbstractMapa.existeMapa(nomreMapa)) {
                this.enviarMensaje(String.format("<red>El mapa %s ya existe", nomreMapa), (CommandSender)sender);
                return;
            }
            if (args.size() < 7) {
                this.enviarMensaje("<red>Uso del Subcomando: /mapa crear nombre x y z x2 y2 z2", (CommandSender)sender);
                return;
            }
            Location esquina1 = Ubicacion.getLocation(sender.getWorld(), 1, args);
            Location esquina2 = Ubicacion.getLocation(sender.getWorld(), 4, args);
            this.invocarConfiguracionMapa(nomreMapa).crear(esquina1, esquina2);
            this.enviarMensaje(String.format("<green>Mapa %s creado con exito!", nomreMapa), (CommandSender)sender);
        }
        if (!AbstractMapa.existeMapa(nomreMapa)) {
            this.enviarMensaje(String.format("<red>El mapa %s no existe.", nomreMapa), (CommandSender)sender);
            return;
        }
        AbstractConfiguracionMapa config = this.invocarConfiguracionMapa(nomreMapa);
        if (subComando.equals("tp")) {
            config.tpJugador(sender);
            return;
        }
        if (subComando.equals("borrar")) {
            config.borrar();
            sender.sendMessage(PyronixPlugin.format(String.format("<green>Mapa %s borrado con exito!", nomreMapa)));
            return;
        }
        if (subComando.equals("guardar")) {
            if (!config.isModoEditorEnabled()) {
                this.enviarMensaje("<red>El mapa tiene que estar en modo edicion primero usa /mapa editor nombre", (CommandSender)sender);
                return;
            }
            config.guardar(sender);
            this.enviarMensaje(String.format("<green>Mapa %s guardado con exito", nomreMapa), (CommandSender)sender);
        }
        if (subComando.equals("editor")) {
            config.modoEditor(sender);
            return;
        }
        if (subComando.equals("reset")) {
            if (!config.isReseteable()) {
                this.enviarMensaje("<red>Lo sentimos los Mapas de este Plugin no son reseteables!", (CommandSender)sender);
                return;
            }
            config.reset();
            this.enviarMensaje(String.format("<green>Mapa %s reseteado con exito", nomreMapa), (CommandSender)sender);
        }
        if (subComando.equals("sustituirTodo")) {
            if (!config.isReseteable()) {
                this.enviarMensaje("<red>Lo sentimos los Mapas de este Plugin no son reseteables por lo tanto tampoco se puede sustituir sus bloques!", (CommandSender)sender);
                return;
            }
            String argumentoMaterial = args.size() > 1 ? args.get(1) : "blue_wool";
            Material material = Material.valueOf((String)argumentoMaterial.toUpperCase());
            config.reset(material);
        }
    }

    @Override
    public List<String> autoCompletarComando(CommandSender sender, Command command, String label, String[] args) {
        Collection<String> autoCompletadoExtra;
        String subComando = args.length > 0 ? args[0] : "";
        ArrayList<String> autoCompletar = new ArrayList<String>();
        List autoCompletarBasico = switch (args.length) {
            case 1 -> List.of("tp", "crear", "editor", "guardar", "reset", "borrar", "sustituirTodo");
            case 2 -> {
                if (subComando.equals("crear")) {
                    yield List.of();
                }
                if (subComando.equals("give")) {
                    yield List.of();
                }
                String[] carpetasMapas = RutasBase.MAPAS.toFile().list();
                if (carpetasMapas == null) {
                    yield List.of();
                }
                yield List.of(carpetasMapas);
            }
            case 3 -> {
                if (subComando.equals("sustituirTodo")) {
                    yield List.of(Material.values()).stream().map(material -> material.toString().toLowerCase()).collect(Collectors.toCollection(ArrayList::new));
                }
                yield List.of();
            }
            default -> List.of();
        };
        autoCompletar.addAll(autoCompletarBasico);
        if (subComando.equals("crear")) {
            autoCompletar.addAll(this.autoCompletarCoordenadas((Player)sender, 3, args.length, 8));
        }
        if ((autoCompletadoExtra = this.onAutoCompleteMapa(sender, subComando, label, args)) != null) {
            autoCompletar.addAll(autoCompletadoExtra);
        }
        return autoCompletar;
    }

    protected final <I extends ItemManager<?, ?, ?>> void darItem(I itemManager, CommandSender sender, String id, int cantidad, Player aDar) {
        if (itemManager == null) {
            return;
        }
        Player player = aDar != null && aDar.isValid() ? aDar : (Player)sender;
        boolean dado = itemManager.darItem(id, player, cantidad);
        if (dado) {
            this.enviarMensaje(String.format("<gold>Se dio a <green>%s <red>%s x %s", player.getName(), id, cantidad), sender);
        } else {
            this.enviarMensaje(String.format("<red>El item %s no existe", id), sender);
        }
    }

    private List<String> quitarPrimerArgumento(String ... args) {
        ArrayList<String> argumentos = new ArrayList<String>(List.of(args));
        if (argumentos.size() > 0) {
            argumentos.remove(0);
        }
        return argumentos;
    }
}

