/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.mapa.generadores;

import es.pyronixstudio.base.core.PyronixScheduler;
import es.pyronixstudio.base.juego.mapa.MarcadorConfiguracion;
import es.pyronixstudio.base.juego.mapa.generadores.EnumTipoGenerador;
import es.pyronixstudio.base.juego.mapa.generadores.Generador;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.EnumEstadoPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class GeneradoresManager
implements PyronixScheduler.PyronixTaskRunnable,
IReseteable {
    private final Set<Generador> generadores = new HashSet<Generador>();
    private final AbstractPartida<?, ?, ?> partida;

    public GeneradoresManager(AbstractPartida<?, ?, ?> partida) {
        this.partida = partida;
    }

    @Override
    public boolean reset(AbstractPartida<?, ?, ?> partida) {
        this.ejecutarFuncionEnTodos(Generador::reset);
        return false;
    }

    private void ejecutarFuncionEnTodos(Consumer<Generador> funcion) {
        this.generadores.forEach(funcion);
    }

    public void partidaIniciada() {
        PyronixScheduler.runTaskTimer(0L, 1L, this);
    }

    public void add(MarcadorConfiguracion generadorConfig) {
        EnumTipoGenerador tipoGenerador = (EnumTipoGenerador)generadorConfig.config.get("generadorTipo").asEnum(EnumTipoGenerador.class);
        Generador generadorInvocado = tipoGenerador.getGenerador(generadorConfig, this.partida);
        this.generadores.add(generadorInvocado);
    }

    @Override
    public void run(PyronixScheduler.PyronixTask task) {
        if (!this.partida.getEstado().haSuperadoOEstaEnEstado(EnumEstadoPartida.INICIADA)) {
            task.cancel();
            return;
        }
        this.ejecutarFuncionEnTodos(Generador::preTick);
        this.ejecutarFuncionEnTodos(Generador::tick);
    }
}

