/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.items.contextos;

import es.pyronixstudio.base.juego.contextos.BaseExecutionContext;
import es.pyronixstudio.base.juego.contextos.ContextExecutionType;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.items.AccionItem;
import es.pyronixstudio.base.juego.items.ItemManager;
import es.pyronixstudio.base.juego.items.ItemPersonalizado;
import es.pyronixstudio.base.juego.items.contextos.ItemExecutionErrors;
import es.pyronixstudio.base.juego.mapa.AbstractMapa;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.EnumEstadoPartida;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.util.CastUtil;
import es.pyronixstudio.util.wrapper.Wrapper;
import org.bukkit.inventory.ItemStack;

public abstract class ItemExecutionContext<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
extends BaseExecutionContext<P> {
    public final Wrapper<ItemPersonalizado> itemPersonalizado = Wrapper.emptyUnmodifiable();
    public final Wrapper<ItemManager<J, E, P>> itemManager = Wrapper.emptyUnmodifiable();
    public final Wrapper<ItemStack> itemStackInvJugador = Wrapper.emptyUnmodifiable();
    public final J jugadorEjecutor;
    public final String idItemPersonalizado;
    private boolean cooldown = true;

    public ItemExecutionContext(ContextExecutionType executionType, J jugadorEjecutor, String idItemPersonalizado) {
        super(executionType, ((AbstractEquipo)((AbstractJugador)jugadorEjecutor).getEquipo()).partida);
        this.jugadorEjecutor = jugadorEjecutor;
        this.idItemPersonalizado = idItemPersonalizado;
    }

    public ItemExecutionContext(ItemManager<J, E, P> itemManager, J jugadorEjecutor, String idItemPersonalizado, ContextExecutionType executionType) {
        this(executionType, jugadorEjecutor, idItemPersonalizado);
        this.itemManager.set(itemManager);
    }

    private void computeItemManager() {
        if (this.itemManager.isEmpty() && this.jugadorEjecutor != null) {
            Object equipo = ((AbstractJugador)this.jugadorEjecutor).getEquipo();
            if (equipo == null) {
                return;
            }
            Object partida = ((AbstractEquipo)equipo).partida;
            if (partida == null) {
                return;
            }
            AbstractMapa mapa = (AbstractMapa)((AbstractPartida)partida).componentSystem.getWithCast(RegistrosBase.COMPONENTES.MAPA);
            if (mapa == null) {
                return;
            }
            this.itemManager.set(mapa.getItemManager());
        }
    }

    public AccionItem<J, E, P> getAccion() {
        return (AccionItem)CastUtil.cast(((ItemPersonalizado)this.itemPersonalizado.get()).getAccion());
    }

    public void disableCooldown() {
        this.cooldown = false;
    }

    public boolean hasCooldown() {
        return this.cooldown;
    }

    @Override
    public final void dispatch() {
        if (this.partida.getEstado() != EnumEstadoPartida.INICIADA) {
            return;
        }
        if (this.itemStackInvJugador.isEmpty()) {
            throw new ItemExecutionErrors.NoItemStackException();
        }
        if (this.itemPersonalizado.isEmpty()) {
            ItemPersonalizado itemInv = (ItemPersonalizado)((AbstractJugador)this.jugadorEjecutor).getItem(this.idItemPersonalizado).get();
            if (itemInv == null) {
                throw new ItemExecutionErrors.NoItemPersonalizadoException();
            }
            this.itemPersonalizado.set((Object)itemInv);
        }
        this.computeItemManager();
        this.itemManager.ifPresent(manager -> {
            this.preDispatch();
            manager.contextHandler.distpatchContext(this);
        }).ifEmpty(() -> {
            throw new ItemExecutionErrors.NoManagerException();
        });
    }
}

