/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.equipo;

import es.pyronixstudio.base.core.PyronixScheduler;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

public class FundidoManager<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
implements PyronixScheduler.PyronixTaskRunnable {
    public static final int MAX = 140;
    private static final int FINAL = 146;
    private static Map<AbstractPartida<?, ?, ?>, PyronixScheduler.PyronixTask> tareasFundido = new HashMap();
    private static final int delayInicial = 20;
    private final P partida;
    private final IFundidoNegro<J, E, P> funciones;
    private E equipoActual;
    private Queue<E> equipos;
    private int ticksFundido = 0;

    public static <J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>> void nuevo(P partida, IFundidoNegro<J, E, P> funcion) {
        new FundidoManager<J, E, P>(partida, funcion);
    }

    private FundidoManager(P partida, IFundidoNegro<J, E, P> funciones) {
        this.partida = partida;
        this.funciones = funciones;
        this.equipos = new ArrayDeque(((AbstractPartida)partida).equipoManager.getAll());
        this.siguiente();
        this.agregarTarea(PyronixScheduler.runTaskTimer(20L, 1L, this));
    }

    private void agregarTarea(PyronixScheduler.PyronixTask task) {
        this.cancelar();
        tareasFundido.put((AbstractPartida<?, ?, ?>)this.partida, task);
    }

    private boolean cancelar() {
        PyronixScheduler.PyronixTask task = tareasFundido.remove(this.partida);
        if (task != null) {
            task.cancel();
            return true;
        }
        return false;
    }

    private void siguiente() {
        this.ticksFundido = 0;
        this.equipoActual = (AbstractEquipo)this.equipos.poll();
        if (this.equipoActual == null) {
            this.funciones.alTerminarFundido();
            this.cancelar();
        }
    }

    @Override
    public void run(PyronixScheduler.PyronixTask task) {
        if (this.equipoActual == null) {
            return;
        }
        ((AbstractEquipo)this.equipoActual).ejecutarFuncionTodosLosJugadores(player -> player.getMinecraftPlayer().setFreezeTicks(this.ticksFundido));
        if (this.ticksFundido >= 146) {
            this.equipoActual = null;
            this.siguiente();
            return;
        }
        this.funciones.tick(this.ticksFundido, this.equipoActual);
        ++this.ticksFundido;
    }

    public static interface IFundidoNegro<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
    extends IFundidoEquipo<J, E, P> {
        default public void alTerminarFundido() {
        }
    }

    public static interface IFundidoEquipo<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>> {
        default public void tick(int tick, E equipoActual) {
            if (tick == 10) {
                this.alEmpezar(equipoActual);
                return;
            }
            if (tick == 140) {
                this.alTerminar(equipoActual);
            }
        }

        default public void alEmpezar(E equipo) {
        }

        default public void alTerminar(E equipo) {
        }
    }
}

