/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.entidades.contextos;

import es.pyronixstudio.base.juego.contextos.ContextExecutionType;
import es.pyronixstudio.base.juego.contextos.EnumHitType;
import es.pyronixstudio.base.juego.entidades.EntidadPersonalizada;
import es.pyronixstudio.base.juego.entidades.EntityManager;
import es.pyronixstudio.base.juego.entidades.contextos.EntityBaseContext;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistrosBase;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;

public class EntityHitContext<CE extends EntidadPersonalizada, J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
extends EntityBaseContext<CE, J, E, P> {
    private final EnumHitType hitType;
    public final Projectile projectile;
    private Block hitBlock;
    private BlockFace hitBlockFace;
    private Entity hitEntity;

    public EntityHitContext(CE entidadCustom, P partida, Projectile projectile, Block hitBlock, BlockFace blockFace) {
        this(entidadCustom, partida, EnumHitType.BLOCK, projectile);
        this.hitBlock = hitBlock;
        this.hitBlockFace = blockFace;
    }

    public EntityHitContext(CE entidadCustom, P partida, Projectile projectile, Entity hitEntity) {
        this(entidadCustom, partida, EnumHitType.ENTITY, projectile);
        this.hitEntity = hitEntity;
    }

    private EntityHitContext(CE entidadCustom, P partida, EnumHitType hitType, Projectile projectile) {
        super(ContextExecutionType.HIT, entidadCustom, partida);
        this.hitType = hitType;
        this.projectile = projectile;
        EntityManager entityManager = (EntityManager)((AbstractPartida)partida).componentSystem.get(RegistrosBase.COMPONENTES.ENTITY_MANAGER);
        if (entityManager != null) {
            entityManager.basuraGeneradaPorEntidad.add(projectile.getUniqueId());
        }
    }

    public boolean isHitBlock() {
        return this.hitType == EnumHitType.BLOCK;
    }

    public boolean isHitEntity() {
        return this.hitType == EnumHitType.ENTITY;
    }

    public Block getHitBlock() {
        return this.hitBlock;
    }

    public Entity getHitEntity() {
        return this.hitEntity;
    }

    public Location getHitLocation() {
        Location location = this.isHitBlock() ? this.hitBlock.getLocation() : this.hitEntity.getLocation();
        return location;
    }
}

