/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.entidades.contextos;

import es.pyronixstudio.base.juego.contextos.ContextExecutionType;
import es.pyronixstudio.base.juego.entidades.EntidadPersonalizada;
import es.pyronixstudio.base.juego.entidades.contextos.EntityBaseContext;
import es.pyronixstudio.base.juego.entidades.contextos.EntityDamageContext;
import es.pyronixstudio.base.juego.entidades.contextos.EntityDeathContext;
import es.pyronixstudio.base.juego.entidades.contextos.EntityExplodeContext;
import es.pyronixstudio.base.juego.entidades.contextos.EntityHitContext;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.items.EstadoEjecuccion;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.util.CastUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class EntityContextHandler<CE extends EntidadPersonalizada, J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>> {
    private final Map<ContextExecutionType, Consumer<? extends EntityBaseContext<CE, J, E, P>>> handlers = new HashMap<ContextExecutionType, Consumer<? extends EntityBaseContext<CE, J, E, P>>>();

    public EntityContextHandler() {
        this.registrarHandler(ContextExecutionType.DEATH, this::entityDeath);
        this.registrarHandler(ContextExecutionType.DAMAGE, this::entityDamage);
        this.registrarHandler(ContextExecutionType.EXPLODE, this::entityExplode);
        this.registrarHandler(ContextExecutionType.HIT, this::entityHit);
    }

    private <C extends EntityBaseContext<CE, J, E, P>> void registrarHandler(ContextExecutionType contextType, Consumer<C> consumidor) {
        this.handlers.putIfAbsent(contextType, consumidor);
    }

    public void distpatchContext(EntityBaseContext<CE, J, E, P> context) {
        Object customEntity = context.customEntity;
        EstadoEjecuccion estadoEjecuccion = context.estadoEjecuccion;
        Consumer<EntityBaseContext<CE, J, E, P>> handler = this.handlers.get((Object)context.executionType);
        handler.accept((EntityBaseContext)CastUtil.cast(context));
    }

    public void entityDeath(EntityDeathContext<CE, J, E, P> context) {
        context.getAccion().onDeath(context);
    }

    public void entityExplode(EntityExplodeContext<CE, J, E, P> context) {
        context.getAccion().onExplode(context);
    }

    public void entityHit(EntityHitContext<CE, J, E, P> context) {
        context.getAccion().onHit(context);
    }

    public void entityDamage(EntityDamageContext<CE, J, E, P> context) {
        context.getAccion().onDamage(context);
    }
}

