/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.entidades;

import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.juego.entidades.EntidadPersonalizada;
import es.pyronixstudio.base.juego.entidades.EntityManager;
import es.pyronixstudio.base.juego.entidades.contextos.EntityBaseContext;
import es.pyronixstudio.base.juego.entidades.contextos.EntityContextHandler;
import es.pyronixstudio.base.juego.entidades.contextos.EntityDamageContext;
import es.pyronixstudio.base.juego.entidades.contextos.EntityExplodeContext;
import es.pyronixstudio.base.juego.entidades.contextos.EntityHitContext;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistradorNameSpaceBase;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.base.util.EntityUtil;
import es.pyronixstudio.base.util.PersistentDataContainerUtil;
import es.pyronixstudio.util.CastUtil;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.function.BiConsumer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;

public class EntityEventManager<CE extends EntidadPersonalizada, J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
implements Listener {
    private final EntityContextHandler<?, ?, ?, ?> contextHandler = new EntityContextHandler();

    @EventHandler
    public void onProjectileHitEvent(ProjectileHitEvent event) {
        Projectile proyectil = event.getEntity();
        Entity shooter = EntityUtil.getShooter((Entity)proyectil);
        this.getCustomObject(shooter, (custom, partida) -> {
            Entity hitEntity = event.getHitEntity();
            Block hitBlock = event.getHitBlock();
            EntityHitContext contexto = hitEntity != null ? new EntityHitContext((EntidadPersonalizada)custom, (AbstractPartida)partida, proyectil, hitEntity) : new EntityHitContext((EntidadPersonalizada)custom, (AbstractPartida)partida, proyectil, hitBlock, event.getHitBlockFace());
            this.launchDispatch(contexto);
        });
    }

    @EventHandler
    public void explosionEvent(EntityExplodeEvent event) {
        Entity eventEntity = event.getEntity();
        this.getCustomObject(eventEntity, (custom, partida) -> {
            EntityExplodeContext contexto = new EntityExplodeContext((EntidadPersonalizada)custom, (AbstractPartida)partida, eventEntity.getLocation());
            this.launchDispatch(contexto);
        });
    }

    @EventHandler
    public void onEntityDeathEvent(EntityDeathEvent event) {
        LivingEntity deathEntity = event.getEntity();
        this.getCustomObject((Entity)deathEntity, (custom, partida) -> {
            EntityDamageByEntityEvent entityDamageByEntityEvent;
            Entity killerEntity;
            AbstractJugador jugador;
            EntityDamageEvent patt0$temp = event.getEntity().getLastDamageCause();
            if (patt0$temp instanceof EntityDamageByEntityEvent && (jugador = (AbstractJugador)partida.jugadorManager.get(killerEntity = (entityDamageByEntityEvent = (EntityDamageByEntityEvent)patt0$temp).getDamager()).get()) == null) {
                return;
            }
        });
    }

    @EventHandler
    public void onEntityDamageByEntityEvent(EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        Entity entidadAcomprobar = damager instanceof Projectile ? EntityUtil.getShooter(damager) : damager;
        this.getCustomObject(entidadAcomprobar, (custom, partida) -> {
            int dano = custom.getDamage();
            if (dano == 0) {
                event.setCancelled(true);
                return;
            }
            event.setDamage((double)dano);
            Entity damaged = event.getEntity();
            EntityDamageContext contexto = null;
            if (damaged instanceof Player) {
                AbstractJugador jugador = (AbstractJugador)partida.jugadorManager.get(damaged).get();
                contexto = new EntityDamageContext((AbstractJugador)((Object)custom), (AbstractPartida)partida, jugador);
            } else {
                CE customEntityDamaged = this.getCustomEntity(damaged, partida);
                if (customEntityDamaged != null) {
                    contexto = new EntityDamageContext((EntidadPersonalizada)custom, (AbstractPartida)partida, (EntidadPersonalizada)customEntityDamaged);
                }
            }
            if (contexto != null) {
                this.launchDispatch(contexto);
            }
        });
    }

    private void launchDispatch(EntityBaseContext<CE, J, E, P> contexto) {
        contexto.handlerWrapper.set(this.contextHandler);
        contexto.dispatch();
    }

    private CE getCustomEntity(Entity entity, P partida) {
        EntityManager entityManager = (EntityManager)((AbstractPartida)partida).componentSystem.get(RegistrosBase.COMPONENTES.ENTITY_MANAGER);
        EntidadPersonalizada entidadPersonalizada = (EntidadPersonalizada)entityManager.get(entity.getUniqueId()).get();
        if (entidadPersonalizada == null) {
            return null;
        }
        return (CE)((EntidadPersonalizada)CastUtil.cast((Object)entidadPersonalizada));
    }

    private void getCustomObject(Entity entity, BiConsumer<CE, P> consumer) {
        String idEntity = (String)PersistentDataContainerUtil.getDataFromHolder((PersistentDataHolder)entity, RegistradorNameSpaceBase.ENTIDAD_PERSONALIZADA, PersistentDataType.STRING);
        Integer idPartida = (Integer)PersistentDataContainerUtil.getDataFromHolder((PersistentDataHolder)entity, RegistradorNameSpaceBase.ENTIDAD_PERSONALIZADA_PARTIDA, PersistentDataType.INTEGER);
        if (idEntity == null || idPartida == null) {
            return;
        }
        AbstractPartida partidaAbs = (AbstractPartida)PyronixPlugin.INSTANCE.partidaManager.get((Wrapper<Integer>)Wrapper.of((Object)idPartida)).get();
        if (partidaAbs == null) {
            return;
        }
        AbstractPartida partida = (AbstractPartida)CastUtil.cast((Object)partidaAbs);
        CE entidadPersonalizada = this.getCustomEntity(entity, partida);
        if (entidadPersonalizada == null) {
            return;
        }
        consumer.accept(entidadPersonalizada, partida);
    }
}

