/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.entidades;

import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.juego.entidades.IAccionEntidad;
import es.pyronixstudio.base.juego.items.ItemManager;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistradorNameSpaceBase;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.base.util.EntityUtil;
import es.pyronixstudio.base.util.PersistentDataContainerUtil;
import es.pyronixstudio.util.ficheros.Elemento;
import java.util.Arrays;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;

public class EntidadPersonalizada {
    private String id;
    private EntityType entityType;
    private int health;
    private int damage;
    private Component name;
    private boolean showName;
    private float scale;
    private String[] drops;
    private Elemento elemento;
    public IAccionEntidad<?, ?, ?, ?> accionEntidad;

    public EntidadPersonalizada(Elemento entityElement) {
        this.cargarDatos(entityElement);
    }

    protected final void cargarDatos(Elemento entityElement) {
        this.id = entityElement.id;
        this.elemento = entityElement;
        entityElement.runAndGetIfExist("type", valor -> {
            this.entityType = (EntityType)valor.asEnum(EntityType.class);
        });
        entityElement.runAndGetIfExist("health", valor -> {
            this.health = valor.asInt();
        });
        entityElement.runAndGetIfExist("damage", valor -> {
            this.damage = valor.asInt();
        });
        entityElement.runAndGetIfExist("name", valor -> {
            this.name = PyronixPlugin.format(valor.asString(), false);
        });
        entityElement.runAndGetIfExist("showName", valor -> {
            this.showName = valor.asBoolean();
        });
        entityElement.runAndGetIfExist("scale", valor -> {
            this.scale = valor.asFloat();
        });
        entityElement.runAndGetIfExist("drops", valor -> {
            this.drops = valor.asStringArray();
        });
        entityElement.runAndGetIfExist("accion", valor -> {
            this.accionEntidad = (IAccionEntidad)RegistrosBase.ACCIONES_ENTIDADES.get(valor.asString()).get();
        });
        if (this.accionEntidad != null) {
            this.accionEntidad.onInit();
        }
        this.cargarDatosExtras(entityElement);
    }

    protected void cargarDatosExtras(Elemento entityElement) {
    }

    public Elemento getElemento() {
        return this.elemento;
    }

    private void aplicarModificadoresAntesDelSpawn(Entity entity) {
        PersistentDataContainerUtil.setDataToHolder((PersistentDataHolder)entity, RegistradorNameSpaceBase.ENTIDAD_PERSONALIZADA, PersistentDataType.STRING, this.id);
        entity.setCustomNameVisible(this.showName);
        entity.customName(this.name);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            EntityUtil.setAttribute(livingEntity, Attribute.MAX_HEALTH, this.health);
            livingEntity.setHealth((double)this.health);
            EntityUtil.setAttribute(livingEntity, Attribute.ATTACK_DAMAGE, this.damage);
            EntityUtil.setAttribute(livingEntity, Attribute.SCALE, this.scale);
        }
        this.aplicarModificadoresExtras(entity);
    }

    protected void aplicarModificadoresExtras(Entity entity) {
    }

    public Entity spawn(Location location) {
        World world = location.getWorld();
        return world.spawnEntity(location, this.entityType, CreatureSpawnEvent.SpawnReason.CUSTOM, this::aplicarModificadoresAntesDelSpawn);
    }

    public void darDrops(AbstractJugador<?, ?, ?> jugador, ItemManager<?, ?, ?> itemManager) {
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public int getHealth() {
        return this.health;
    }

    public int getDamage() {
        return this.damage;
    }

    public Component getName() {
        return this.name;
    }

    public boolean isShowName() {
        return this.showName;
    }

    public float getScale() {
        return this.scale;
    }

    public String[] getDrops() {
        return this.drops;
    }

    public String toString() {
        return "EntidadPersonalizada{id='" + this.id + "', entityType=" + String.valueOf(this.entityType) + ", health=" + this.health + ", damage=" + this.damage + ", name=" + String.valueOf(this.name) + ", showName=" + this.showName + ", scale=" + this.scale + ", drops=" + Arrays.toString(this.drops) + "}";
    }
}

