/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.bloques;

import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.base.registros.tipo.IRegistro;
import es.pyronixstudio.base.sonido.SonidoBase;
import es.pyronixstudio.base.sonido.SonidoManager;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Saltadores {
    public static void saltarHorizontal(float impulso, float altura, AbstractJugador<?, ?, ?> jugador) {
        Saltadores.saltarHorizontal(impulso, altura, jugador, null);
    }

    public static void saltarHorizontal(float impulso, float altura, AbstractJugador<?, ?, ?> jugador, IRegistro<SonidoBase> sonidoCustom) {
        Player player = jugador.getMinecraftPlayer();
        float direcionJugador = jugador.getMinecraftPlayer().getEyeLocation().clone().getYaw();
        double radianes = Math.toRadians(direcionJugador);
        Vector vector = new Vector(-1.0 * Math.sin(radianes), 0.0, Math.cos(radianes)).multiply(impulso);
        vector.setY(altura);
        Player entidad = player.getVehicle() != null ? player.getVehicle() : player;
        entidad.setVelocity(vector);
        IRegistro<SonidoBase> sonido = sonidoCustom != null ? sonidoCustom : RegistrosBase.SONIDOS.SONIDO_PROPULSOR;
        SonidoManager.reproducirSonidoAJugador(player, sonido, 1.0f, 1.0f);
    }

    public static void saltarVertical(float altura, AbstractJugador<?, ?, ?> jugador) {
        Saltadores.saltarVertical(altura, jugador, null);
    }

    public static void saltarVertical(float altura, AbstractJugador<?, ?, ?> jugador, IRegistro<SonidoBase> sonidoCustom) {
        Player player = jugador.getMinecraftPlayer();
        Vector impulsoVector = new Vector(0, 2, 0).multiply(altura);
        Player entidad = player.getVehicle() != null ? player.getVehicle() : player;
        entidad.setVelocity(impulsoVector);
        IRegistro<SonidoBase> sonido = sonidoCustom != null ? sonidoCustom : RegistrosBase.SONIDOS.SONIDO_PROPULSOR;
        SonidoManager.reproducirSonidoAJugador(player, sonido, 1.0f, 1.0f);
    }
}

