/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.entidades;

import es.pyronixstudio.base.core.RutasBase;
import es.pyronixstudio.base.juego.entidades.EntidadPersonalizada;
import es.pyronixstudio.base.juego.entidades.EntidadPersonalizadaExceptions;
import es.pyronixstudio.base.juego.mapa.AbstractMapa;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.IManager;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.util.ficheros.Elemento;
import es.pyronixstudio.util.ficheros.PyronixFile;
import es.pyronixstudio.util.ficheros.Valor;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.entity.Entity;

public class EntityManager<E extends EntidadPersonalizada>
implements IManager<UUID, E>,
IReseteable {
    private final Map<UUID, E> entities = new HashMap<UUID, E>();
    private final Map<String, E> registerEntities = new HashMap<String, E>();
    private final Function<Elemento, E> entityFactory;
    private final AbstractPartida<?, ?, ?> partida;

    public EntityManager(AbstractPartida<?, ?, ?> partida, Function<Elemento, E> entityFactory) {
        this.entityFactory = entityFactory;
        this.partida = partida;
        this.registerEntities();
    }

    private void registerEntities() {
        PyronixFile mapFile;
        ArrayList<PyronixFile> ficheros = new ArrayList<PyronixFile>();
        ficheros.add(RutasBase.ENTITIES_FICHERO);
        AbstractMapa mapa = (AbstractMapa)this.partida.componentSystem.get(RegistrosBase.COMPONENTES.MAPA);
        if (mapa != null && (mapFile = RutasBase.ENTITIES_FICHERO_MAPA.apply(mapa.nombreUnico)).existe()) {
            ficheros.add(mapFile);
        }
        LinkedList<Map.Entry<Elemento, String>> childs = new LinkedList<Map.Entry<Elemento, String>>();
        for (PyronixFile file : ficheros) {
            file.parsear();
            List ids = file.getIds();
            for (String id : ids) {
                Elemento elemento = file.getElemento(id);
                Valor parent = elemento.get("parent");
                if (parent != null) {
                    childs.add(Map.entry(elemento, parent.asString()));
                    continue;
                }
                this.registerEntities.put(id, (EntidadPersonalizada)this.entityFactory.apply(elemento));
            }
        }
        while (!childs.isEmpty()) {
            Map.Entry childEntry = (Map.Entry)childs.poll();
            Elemento child = (Elemento)childEntry.getKey();
            String parentId = (String)childEntry.getValue();
            Elemento parent = ((EntidadPersonalizada)this.registerEntities.get(child.id)).getElemento();
            if (parent == null) {
                throw new EntidadPersonalizadaExceptions.EntidadPersonalizadaNoParentFoundException(child.id, parentId);
            }
            EntidadPersonalizada entidad = (EntidadPersonalizada)this.entityFactory.apply(parent);
            entidad.cargarDatos(child);
            this.registerEntities.put(child.id, entidad);
        }
    }

    public Wrapper<E> getCustomEntities(String id) {
        return Wrapper.of((Object)((EntidadPersonalizada)this.registerEntities.get(id)));
    }

    @Override
    public void add(UUID uuid, E customEntity) {
        this.entities.computeIfAbsent(uuid, k -> customEntity);
    }

    @Override
    public final Wrapper<E> get(Entity minecraftEntity) {
        if (minecraftEntity == null) {
            return Wrapper.empty();
        }
        return this.get(minecraftEntity.getUniqueId());
    }

    @Override
    public Wrapper<E> get(UUID uuid) {
        return Wrapper.of((Object)((EntidadPersonalizada)this.entities.get(uuid)));
    }

    @Override
    public Collection<E> getAll() {
        return this.entities.values();
    }

    @Override
    public Collection<UUID> getAllKeys() {
        return this.entities.keySet();
    }

    @Override
    public void remove(UUID uuid) {
        this.entities.remove(uuid);
    }

    @Override
    public void removeAll() {
        this.entities.clear();
    }

    @Override
    public boolean reset(AbstractPartida<?, ?, ?> partida) {
        this.registerEntities.clear();
        this.entities.clear();
        return false;
    }
}

