/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.entidades;

import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.juego.entidades.EntidadPersonalizada;
import es.pyronixstudio.base.juego.entidades.EntityManager;
import es.pyronixstudio.base.juego.entidades.contextos.EntityHitContext;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.registros.RegistradorNameSpaceBase;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.base.util.EntityUtil;
import es.pyronixstudio.base.util.PersistentDataContainerUtil;
import es.pyronixstudio.util.CastUtil;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.function.BiConsumer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrowableProjectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;

public class EntityEventManager
implements Listener {
    @EventHandler
    public void onProjectileHitEvent(ProjectileHitEvent event) {
        Projectile proyectil = event.getEntity();
        if (proyectil instanceof ThrowableProjectile) {
            ThrowableProjectile proyectilLanzable = (ThrowableProjectile)proyectil;
            Entity shooter = EntityUtil.getShooter((Entity)proyectil);
            this.getCustomObject(shooter, (en, p) -> {
                Entity hitEntity = event.getHitEntity();
                Block hitBlock = event.getHitBlock();
                EntityHitContext<EntidadPersonalizada, AbstractPartida> contexto = hitEntity != null ? new EntityHitContext<EntidadPersonalizada, AbstractPartida>((EntidadPersonalizada)en, (AbstractPartida)CastUtil.cast((Object)p), proyectil, hitEntity) : new EntityHitContext<EntidadPersonalizada, AbstractPartida>((EntidadPersonalizada)en, (AbstractPartida)CastUtil.cast((Object)p), proyectil, hitBlock, event.getHitBlockFace());
                en.accionEntidad.onHit((EntityHitContext)CastUtil.cast(contexto));
            });
        }
    }

    private void getCustomObject(Entity entity, BiConsumer<? super EntidadPersonalizada, AbstractPartida<?, ?, ?>> consumer) {
        String idEntity = (String)PersistentDataContainerUtil.getDataFromHolder((PersistentDataHolder)entity, RegistradorNameSpaceBase.ENTIDAD_PERSONALIZADA, PersistentDataType.STRING);
        Integer idPartida = (Integer)PersistentDataContainerUtil.getDataFromHolder((PersistentDataHolder)entity, RegistradorNameSpaceBase.ENTIDAD_PERSONALIZADA_PARTIDA, PersistentDataType.INTEGER);
        if (idEntity == null || idPartida == null) {
            return;
        }
        AbstractPartida partidaAbs = (AbstractPartida)PyronixPlugin.INSTANCE.partidaManager.get((Wrapper<Integer>)Wrapper.of((Object)idPartida)).get();
        if (partidaAbs == null) {
            return;
        }
        EntityManager entityManager = (EntityManager)partidaAbs.componentSystem.get(RegistrosBase.COMPONENTES.ENTITY_MANAGER);
        EntidadPersonalizada entidadPersonalizada = (EntidadPersonalizada)entityManager.get(entity.getUniqueId()).get();
        if (entidadPersonalizada == null) {
            return;
        }
        consumer.accept(entidadPersonalizada, partidaAbs);
    }
}

