/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.areas;

import es.pyronixstudio.base.componentes.SistemaComponente;
import es.pyronixstudio.base.juego.ITickable;
import es.pyronixstudio.base.juego.areas.AreaErrores;
import es.pyronixstudio.base.juego.areas.AreasManager;
import es.pyronixstudio.base.juego.areas.BaseParticulasHelperAreas;
import es.pyronixstudio.base.juego.areas.IAreaRenderable;
import es.pyronixstudio.base.juego.entidades.EntidadPersonalizada;
import es.pyronixstudio.base.juego.entidades.EntityManager;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.equipo.EnumColor;
import es.pyronixstudio.base.juego.items.contextos.ItemExecutionContext;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.base.registros.tipo.IRegistro;
import es.pyronixstudio.base.util.Ubicacion;
import es.pyronixstudio.util.CastUtil;
import es.pyronixstudio.util.ficheros.Valor;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public abstract class Area<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
implements IReseteable {
    public Ubicacion.EsquinasLocationRecord esquinas;
    protected final Set<UUID> dentro = new HashSet<UUID>();
    protected final Valor[] args;
    protected final P partida;
    protected final SistemaComponente componentSystem;
    protected final Location centro;
    public final int maxTicks;
    private final int areaX;
    private final int areaY;
    private final int areaZ;
    private final AreasManager<?, ?, ?> manager;
    private final boolean onlyTickTeamColor;
    private final boolean checkCustomEntities;
    private final Wrapper<BaseParticulasHelperAreas> renderableHelper = Wrapper.emptyUnmodifiable();

    public Area(Builder builder) {
        this.args = builder.args;
        this.esquinas = builder.esquinas;
        this.partida = (AbstractPartida)CastUtil.cast(builder.partida);
        this.componentSystem = builder.componentSystem;
        this.centro = builder.centro;
        this.maxTicks = builder.maxTicks;
        this.areaX = builder.areaX;
        this.areaY = builder.areaY;
        this.areaZ = builder.areaZ;
        this.manager = builder.areasManager;
        this.onlyTickTeamColor = builder.onlyTickTeam;
        this.checkCustomEntities = builder.checkCustomEntities;
        ((AbstractPartida)this.partida).resetManager.agregarObjeto(this);
    }

    public void registrarParticulas() {
        Area area = this;
        if (area instanceof IAreaRenderable) {
            IAreaRenderable renderable = (IAreaRenderable)((Object)area);
            renderable.setParticleHelper(this.renderableHelper);
        }
    }

    private void updateArea() {
        Entity entidad = (Entity)this.componentSystem.get(RegistrosBase.COMPONENTES.ENTIDAD_TRACKEADA_AREA);
        if (entidad == null) {
            return;
        }
        if (!entidad.isValid()) {
            this.desregistrar();
            return;
        }
        Location nuevaUbicacion = entidad.getLocation();
        this.esquinas = Ubicacion.getEsquinarRelativa(nuevaUbicacion, this.areaX, this.areaY, this.areaZ);
        this.renderableHelper.ifPresent(BaseParticulasHelperAreas::update);
    }

    private boolean isInside(Entity entity) {
        if (!entity.isValid() || entity.isDead()) {
            return false;
        }
        Location location = entity.getLocation();
        if (location.getWorld() != this.esquinas.world) {
            return false;
        }
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        return x >= this.esquinas.menorX && x <= this.esquinas.maxX && y >= this.esquinas.menorY && y <= this.esquinas.maxY && z >= this.esquinas.menorZ && z <= this.esquinas.maxZ;
    }

    private void processTransition(UUID uuid, boolean inside, Runnable onEnter, Runnable onExit) {
        boolean wasInside = this.dentro.contains(uuid);
        if (inside && !wasInside) {
            this.dentro.add(uuid);
            onEnter.run();
        } else if (!inside && wasInside) {
            this.dentro.remove(uuid);
            onExit.run();
        }
    }

    private void checkJugador(J jugador) {
        Player entity = ((AbstractJugador)jugador).getMinecraftPlayer();
        UUID uuid = entity.getUniqueId();
        this.processTransition(uuid, this.isInside((Entity)entity), () -> this.onEnter(jugador), () -> this.onExit(jugador));
    }

    private void checkCustomEntities() {
        EntityManager entitityManager = (EntityManager)((AbstractPartida)this.partida).componentSystem.get(RegistrosBase.COMPONENTES.ENTITY_MANAGER);
        if (entitityManager == null) {
            return;
        }
        entitityManager.getAllKeys().forEach(uuid -> {
            Entity entity = Bukkit.getEntity((UUID)uuid);
            EntidadPersonalizada custom = (EntidadPersonalizada)entitityManager.get((UUID)uuid).get();
            if (entity == null || custom == null) {
                return;
            }
            this.processTransition((UUID)uuid, this.isInside(entity), () -> this.onCustomEntityEnter(custom, entity), () -> this.onCustomEntityExit(custom, entity));
        });
    }

    public final void comprobarColisiones() {
        this.updateArea();
        if (this.checkCustomEntities) {
            this.checkCustomEntities();
        }
        if (!this.onlyTickTeamColor) {
            ((AbstractPartida)this.partida).jugadorManager.forEach(this::checkJugador);
        } else {
            EnumColor color = (EnumColor)((Object)this.componentSystem.get(RegistrosBase.COMPONENTES.COLOR));
            if (color == null) {
                throw new AreaErrores.MissingTeamForOnlyTeamTickAreaException();
            }
            AbstractEquipo equipo = (AbstractEquipo)((AbstractPartida)this.partida).equipoManager.get(color).get();
            if (equipo == null) {
                this.desregistrar();
                return;
            }
            equipo.ejecutarFuncionTodosLosJugadores(this::checkJugador);
        }
        this.renderableHelper.ifPresent(BaseParticulasHelperAreas::tick);
        ITickable.tickIfInstance(this);
    }

    protected void desregistrar() {
        this.manager.remove(this.centro);
    }

    protected abstract void onEnter(J var1);

    protected abstract void onExit(J var1);

    protected void onCustomEntityEnter(EntidadPersonalizada entidadPersonalizada, Entity minecraftEntity) {
    }

    protected void onCustomEntityExit(EntidadPersonalizada entidadPersonalizada, Entity minecraftEntity) {
    }

    protected void alDesregistrarse() {
    }

    public String toString() {
        return String.format("Area=[Esquinas:%s, Jugadores:%s, Args:%s, MaxTicks:%s]", this.esquinas, this.dentro, Arrays.toString(this.args), this.maxTicks);
    }

    private static Wrapper<Builder> newBuilder(Function<Builder, Area<?, ?, ?>> constructor, AbstractPartida<?, ?, ?> partida) {
        if (constructor == null) {
            return Wrapper.emptyUnmodifiable();
        }
        return Wrapper.ofUnmodifiable((Object)new Builder(constructor, partida));
    }

    public static Wrapper<Builder> newBuilder(IRegistro<Function<Builder, Area<?, ?, ?>>> registroArea, AbstractPartida<?, ?, ?> partida) {
        if (registroArea.isEmpty()) {
            return Wrapper.emptyUnmodifiable();
        }
        return Area.newBuilder(registroArea.crear(), partida);
    }

    public static Wrapper<Builder> newBuilder(IRegistro<Function<Builder, Area<?, ?, ?>>> supplierConstructor, AbstractJugador<?, ?, ?> jugador) {
        return Area.newBuilder(supplierConstructor, jugador.getEquipo());
    }

    public static Wrapper<Builder> newBuilder(IRegistro<Function<Builder, Area<?, ?, ?>>> supplierConstructor, ItemExecutionContext<?, ?, ?> contexto) {
        return Area.newBuilder(supplierConstructor, contexto.jugadorEjecutor);
    }

    public static Wrapper<Builder> newBuilder(IRegistro<Function<Builder, Area<?, ?, ?>>> supplierConstructor, AbstractEquipo<?, ?, ?> equipo) {
        return Area.newBuilder(supplierConstructor.crear(), equipo.partida);
    }

    public static class Builder {
        private Valor[] args = new Valor[0];
        private Location centro;
        private Ubicacion.EsquinasLocationRecord esquinas;
        private final Function<Builder, Area<?, ?, ?>> constructor;
        private final AbstractPartida<?, ?, ?> partida;
        public final SistemaComponente componentSystem = SistemaComponente.create();
        private int maxTicks = -1;
        private AreasManager<?, ?, ?> areasManager;
        private boolean onlyTickTeam = false;
        private boolean checkCustomEntities = false;
        private Location esquina1;
        private Location esquina2;
        private int areaX;
        private int areaY;
        private int areaZ;

        private Builder(Function<Builder, Area<?, ?, ?>> constructor, AbstractPartida<?, ?, ?> partida) {
            this.constructor = constructor;
            this.partida = partida;
        }

        public Builder set(int area) {
            return this.set(area, area, area);
        }

        public Builder set(int areaX, int areaY, int areaZ) {
            this.areaX = areaX;
            this.areaY = areaY;
            this.areaZ = areaZ;
            return this;
        }

        public Builder set(Location esquina, Location esquina2) {
            this.esquina1 = esquina;
            this.esquina2 = esquina2;
            return this;
        }

        public Builder setCentro(Location centro) {
            this.centro = centro;
            return this;
        }

        public Builder maxTicks(int maxTicks) {
            this.maxTicks = maxTicks;
            return this;
        }

        public Builder args(Valor[] args) {
            this.args = args;
            return this;
        }

        public Builder setAreaManager(AreasManager<?, ?, ?> areasManager) {
            this.areasManager = areasManager;
            return this;
        }

        public Builder setTrackedEntity(Entity entity) {
            this.componentSystem.add(RegistrosBase.COMPONENTES.ENTIDAD_TRACKEADA_AREA, entity);
            return this;
        }

        public Builder setOnlyTickTeam() {
            this.onlyTickTeam = true;
            return this;
        }

        public Builder checkCustomEntities() {
            this.checkCustomEntities = true;
            return this;
        }

        public final Area<?, ?, ?> build() {
            this.esquinas = this.esquina1 == null || this.esquina2 == null ? Ubicacion.getEsquinarRelativa(this.centro, this.areaX, this.areaY, this.areaZ) : Ubicacion.getLocacionCoordsMenorMayor(this.esquina1, this.esquina2);
            Area<?, ?, ?> area = this.constructor.apply(this);
            area.registrarParticulas();
            return area;
        }
    }
}

