/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.mapa.generadores;

import es.pyronixstudio.base.juego.entidades.EntidadPersonalizada;
import es.pyronixstudio.base.juego.entidades.EntityManager;
import es.pyronixstudio.base.juego.mapa.MarcadorConfiguracion;
import es.pyronixstudio.base.juego.mapa.generadores.Generador;
import es.pyronixstudio.base.juego.mapa.generadores.generado.GeneradoEntidadPersonalizada;
import es.pyronixstudio.base.juego.mapa.generadores.generado.IGenerado;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.util.CastUtil;
import es.pyronixstudio.util.RandomUtil;
import es.pyronixstudio.util.colecciones.IndexedMap;
import es.pyronixstudio.util.ficheros.Valor;
import es.pyronixstudio.util.wrapper.Wrapper;

public class GeneradorEntidad
extends Generador {
    private final IndexedMap<EntidadPersonalizada, Integer> entidadesAGenerar;
    private final EntityManager<?> entityManager;

    public GeneradorEntidad(MarcadorConfiguracion marcadorConfig, AbstractPartida<?, ?, ?> partida) {
        super(marcadorConfig, partida);
        IndexedMap crearMapa = null;
        this.entityManager = (EntityManager)partida.componentSystem.get(RegistrosBase.COMPONENTES.ENTITY_MANAGER);
        if (this.entityManager != null) {
            crearMapa = IndexedMap.of(this.getElementosAGenerar(), key -> {
                Wrapper optEntity = (Wrapper)CastUtil.cast(this.entityManager.getCustomEntities((String)key));
                if (optEntity.isPresent()) {
                    return (EntidadPersonalizada)optEntity.get();
                }
                return null;
            }, Valor::asInt);
        }
        this.entidadesAGenerar = crearMapa;
    }

    @Override
    protected void procesarPreTick() {
    }

    @Override
    protected void procesarTick() {
    }

    @Override
    protected IGenerado generar(Generador.UbicacionTickeable location) {
        IndexedMap.IndexedEntry parejaGenerar;
        IndexedMap.IndexedEntry indexedEntry = parejaGenerar = this.random ? RandomUtil.getRandomFromIndexedMap(this.entidadesAGenerar) : this.entidadesAGenerar.getFirst();
        if (parejaGenerar == null) {
            return null;
        }
        int porGenerar = (Integer)parejaGenerar.getValue();
        if (porGenerar == 0) {
            return null;
        }
        if (porGenerar != -1) {
            int nuevoMaximo;
            if ((nuevoMaximo = --porGenerar) == 0) {
                parejaGenerar.remove();
            } else {
                parejaGenerar.setValue((Object)nuevoMaximo);
            }
        }
        EntidadPersonalizada aGenerar = (EntidadPersonalizada)parejaGenerar.getKey();
        GeneradoEntidadPersonalizada entidadPersonalizadaIGenerado = GeneradoEntidadPersonalizada.of(location, aGenerar);
        this.entityManager.add(entidadPersonalizadaIGenerado.getUUID(), (EntidadPersonalizada)CastUtil.cast((Object)aGenerar));
        return entidadPersonalizadaIGenerado;
    }
}

