/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.partida;

import es.pyronixstudio.base.comandos.Argumentos;
import es.pyronixstudio.base.componentes.SistemaComponente;
import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.juego.entidades.EntidadPersonalizada;
import es.pyronixstudio.base.juego.entidades.EntityManager;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.equipo.AbstractPlayerTeamFactory;
import es.pyronixstudio.base.juego.equipo.EnumColor;
import es.pyronixstudio.base.juego.equipo.EquipoManager;
import es.pyronixstudio.base.juego.equipo.FundidoManager;
import es.pyronixstudio.base.juego.partida.CuentaAtras;
import es.pyronixstudio.base.juego.partida.EnumEstadoPartida;
import es.pyronixstudio.base.juego.partida.ResetManager;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.juego.partida.jugador.JugadorManager;
import es.pyronixstudio.base.juego.puntuaciones.AbstractPuntuacionManager;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.base.registros.tipo.IRegistro;
import es.pyronixstudio.base.sonido.SonidoBase;
import es.pyronixstudio.base.sonido.SonidoManager;
import es.pyronixstudio.util.CastUtil;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerLoginEvent;

public abstract class AbstractPartida<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
implements Listener {
    protected EnumEstadoPartida estado = EnumEstadoPartida.NO_INICIALIZADA;
    protected final AbstractPlayerTeamFactory<J, E, P> creadorJugadoresEquipos;
    public final ResetManager resetManager;
    public final EquipoManager<J, E, P> equipoManager;
    public final JugadorManager<J, E, P> jugadorManager;
    public final EntityManager<? super EntidadPersonalizada> entityManager;
    public PyronixPlugin<J, E, P> plugin;
    private final String bloqueAsignarEquipo = (String)Wrapper.of((Object)PyronixPlugin.INSTANCE.getConfig().getString("bloqueAsignarEquipo")).getOrDefault((Object)"glazed_terracotta");
    public final SistemaComponente componentSystem = SistemaComponente.create();

    protected AbstractPartida() {
        this.resetManager = new ResetManager(this);
        this.equipoManager = new EquipoManager();
        this.jugadorManager = new JugadorManager();
        this.entityManager = new EntityManager();
        this.creadorJugadoresEquipos = this.getCreador();
    }

    public final void setPlugin(PyronixPlugin<J, E, P> plugin) {
        this.plugin = plugin;
    }

    public final EnumEstadoPartida getEstado() {
        return this.estado;
    }

    public final synchronized void setEstado(EnumEstadoPartida estadoPartida) {
        this.estado = estadoPartida;
    }

    public final void volverAPreinicializarEquiposYJugadores() {
        this.equipoManager.forEach(equipo -> {
            this.creadorJugadoresEquipos.preInicializarBase((AbstractEquipo)equipo);
            ArrayList nuevaLista = new ArrayList();
            equipo.ejecutarFuncionTodosLosJugadores(jugador -> {
                Player playerSinRenovar = jugador.getMinecraftPlayer();
                UUID uuid = playerSinRenovar.getUniqueId();
                Player playerRenovado = Bukkit.getPlayer((UUID)uuid);
                Wrapper<J> jugadorOptional = this.jugadorManager.get(uuid);
                if (playerRenovado.isOnline()) {
                    AbstractJugador jugadorRenovado;
                    if (jugadorOptional.isEmpty()) {
                        jugadorRenovado = this.creadorJugadoresEquipos.crearJugador(playerRenovado, (AbstractEquipo)equipo, false);
                        this.jugadorManager.add(uuid, jugadorRenovado);
                    } else {
                        jugadorRenovado = (AbstractJugador)jugadorOptional.get();
                    }
                    jugadorRenovado.actualizarInstancia(playerRenovado);
                    nuevaLista.add(jugadorRenovado);
                }
            });
            equipo.setJugadores(nuevaLista);
        });
    }

    public abstract void crear(Argumentos var1);

    public final void preIniciar(Argumentos argumentos) {
        this.preIniciarExtra(argumentos);
        this.equipoManager.forEach(AbstractEquipo::preIniciar);
        this.iniciar(argumentos);
        if (argumentos.asError()) {
            this.reset();
            return;
        }
        AbstractPuntuacionManager managerPuntuaciones = (AbstractPuntuacionManager)this.componentSystem.get(RegistrosBase.COMPONENTES.PUNTUACIONES_MANAGER);
        if (managerPuntuaciones != null) {
            managerPuntuaciones.alIniciarPartida();
        }
    }

    protected void preIniciarExtra(Argumentos argumentos) {
    }

    protected abstract void iniciar(Argumentos var1);

    protected abstract void terminarExtra();

    public void terminar() {
        this.setEstado(EnumEstadoPartida.TERMINADA);
        this.terminarExtra();
        SonidoManager.reproducirAudioATodosEnPartida(this.jugadorManager, RegistrosBase.SONIDOS.PARTIDA_TERMINADA, 1.0f, 1.0f);
        AbstractPuntuacionManager managerPuntuaciones = (AbstractPuntuacionManager)this.componentSystem.get(RegistrosBase.COMPONENTES.PUNTUACIONES_MANAGER);
        if (managerPuntuaciones != null) {
            managerPuntuaciones.partidaTerminada();
        }
    }

    public abstract AbstractPlayerTeamFactory<J, E, P> getCreador();

    public void meterJugadoresAEquipo() {
        int maxColores = EnumColor.values().length;
        for (Player player : Bukkit.getOnlinePlayers()) {
            EnumColor colorEnum;
            Material bloqueAbajo = player.getLocation().add(0.0, -1.0, 0.0).getBlock().getType();
            UUID uuidJugador = player.getUniqueId();
            if (!bloqueAbajo.toString().toLowerCase().contains(this.bloqueAsignarEquipo.toLowerCase()) || this.jugadorManager.get(uuidJugador).isPresent() || this.equipoManager.get(uuidJugador).isPresent() || (colorEnum = EnumColor.getEnumFromMaterial(bloqueAbajo)) == null || this.equipoManager.size() > maxColores && !this.equipoManager.contains(colorEnum)) continue;
            AbstractEquipo equipoCreado = this.equipoManager.addIfNotExists(colorEnum, this.creadorJugadoresEquipos::crearEquipo);
            J jugador = this.creadorJugadoresEquipos.crearJugador(player, equipoCreado, true);
            this.jugadorManager.add(uuidJugador, jugador);
            equipoCreado.agregarJugador(jugador);
        }
    }

    protected void cuentaAtras(Runnable alTerminar) {
        this.cuentaAtras(alTerminar, 5);
    }

    protected void cuentaAtras(Runnable alTerminar, int delayAntesDeEjecucion) {
        this.cuentaAtras(alTerminar, delayAntesDeEjecucion, null);
    }

    protected void cuentaAtras(Runnable alTerminar, int delayAntesDeEjecucion, IRegistro<SonidoBase> sonidoAJugar) {
        CuentaAtras.nuevaCuentaAtras(this, alTerminar, delayAntesDeEjecucion, sonidoAJugar == null ? RegistrosBase.SONIDOS.A_JUGAR : sonidoAJugar);
    }

    protected final void fundidoNegro(FundidoManager.IFundidoNegro<J, E, P> fundido) {
        FundidoManager.nuevo((AbstractPartida)CastUtil.cast((Object)this), fundido);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void onPlayerLogginEventImportant(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        this.jugadorManager.get((Entity)player).ifPresent(jugador -> jugador.actualizarInstancia(player));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void onPlayerDeadEventImportant(PlayerDeathEvent event) {
        Player player = event.getEntity();
        this.jugadorManager.get((Entity)player).ifPresent(jugador -> jugador.alMorir(this.jugadorManager.get((Entity)player.getKiller()), player.getLocation().clone()));
    }

    protected void enviarTitulo(String titulo, String subtitulo, int fadeIn, int stay, int fadeOut) {
        Title tituloCreado = Title.title((Component)PyronixPlugin.format(titulo, false), (Component)PyronixPlugin.format(subtitulo, false), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(fadeIn), (Duration)Duration.ofMillis(stay), (Duration)Duration.ofMillis(fadeOut)));
        this.jugadorManager.forEach(jugador -> {
            Player player = jugador.getMinecraftPlayer();
            if (jugador.esMinecraftPlayerValido()) {
                player.showTitle(tituloCreado);
                player.playSound((Entity)player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            }
        });
    }

    public void borrarEquipos() {
        this.equipoManager.removeAll();
        this.jugadorManager.removeAll();
    }

    public void resetExtra() {
    }

    public final void reset() {
        this.resetExtra();
        this.resetManager.reset();
        this.jugadorManager.removeAll();
        this.componentSystem.remove(RegistrosBase.COMPONENTES.MAPA);
        this.setEstado(EnumEstadoPartida.INICIALIZADA);
    }

    public final void resetCompleto() {
        this.resetExtraCompleto();
        this.reset();
        PyronixPlugin.desregistrarEventos(this);
        this.resetManager.resetCompleto();
        this.borrarEquipos();
    }

    public void resetExtraCompleto() {
    }
}

