/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.entidades;

import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.juego.items.ItemPersonalizado;
import es.pyronixstudio.base.registros.RegistradorNameSpaceBase;
import es.pyronixstudio.base.util.EntityUtil;
import es.pyronixstudio.base.util.PersistentDataContainerUtil;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;

public class EntidadPersonalizada {
    public final String id;
    public final EntityType entityType;
    public final int health;
    public final int damage;
    public final Component name;
    public final boolean showName;
    public final float scale;
    public final ItemPersonalizado[] drops;

    private EntidadPersonalizada(Builder builder) {
        this.id = builder.id;
        this.entityType = builder.entityType;
        this.health = builder.health;
        this.damage = builder.damage;
        this.name = builder.name;
        this.showName = builder.showName;
        this.scale = builder.scale;
        this.drops = builder.drops;
    }

    private void aplicarModificadoresAntesDelSpawn(Entity entity) {
        PersistentDataContainerUtil.setDataToHolder((PersistentDataHolder)entity, RegistradorNameSpaceBase.ENTIDAD_PERSONALIZADA, PersistentDataType.STRING, this.id);
        entity.setCustomNameVisible(this.showName);
        entity.customName(this.name);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            EntityUtil.setAttribute(livingEntity, Attribute.MAX_HEALTH, this.health);
            livingEntity.setHealth((double)this.health);
            EntityUtil.setAttribute(livingEntity, Attribute.ATTACK_DAMAGE, this.damage);
            EntityUtil.setAttribute(livingEntity, Attribute.SCALE, this.scale);
        }
    }

    public Entity spawn(Location location) {
        World world = location.getWorld();
        return world.spawnEntity(location, this.entityType, CreatureSpawnEvent.SpawnReason.CUSTOM, this::aplicarModificadoresAntesDelSpawn);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private EntityType entityType;
        private int health;
        private int damage;
        private Component name;
        private boolean showName;
        private float scale;
        private ItemPersonalizado[] drops;
        private String parent;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setEntityType(EntityType type) {
            this.entityType = type;
            return this;
        }

        public Builder setHealth(int health) {
            this.health = health;
            return this;
        }

        public Builder setDamage(int damage) {
            this.damage = damage;
            return this;
        }

        public Builder setName(String name) {
            this.name = PyronixPlugin.format(name, false);
            return this;
        }

        public Builder setShowName(boolean showName) {
            this.showName = showName;
            return this;
        }

        public Builder setScale(float scale) {
            this.scale = scale;
            return this;
        }

        public Builder setDrops(ItemPersonalizado[] drops) {
            this.drops = drops;
            return this;
        }

        public Builder setParent(String parentID) {
            this.parent = parentID;
            return this;
        }

        public EntidadPersonalizada build() {
            return new EntidadPersonalizada(this);
        }
    }
}

