/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.estructuras;

import es.pyronixstudio.base.core.RutasBase;
import es.pyronixstudio.base.util.Ubicacion;
import es.pyronixstudio.util.EnumUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class Patron {
    private final List<BloqueEstructura> bloques = new ArrayList<BloqueEstructura>();
    public final String id;

    public static Patron create(String id) {
        return new Patron(id);
    }

    private Patron(String id) {
        this.id = id;
    }

    public void parsear() {
        List lineasFichero = RutasBase.PATRONES_FICHERO.apply(this.id).getAllLines();
        lineasFichero.forEach(linea -> {
            String coords;
            String[] coordsSplitted;
            if (linea.isBlank() || linea.startsWith("//")) {
                return;
            }
            Object splitted = null;
            Material material = Material.STONE;
            if (linea.contains(":")) {
                linea.split(":");
                if ((splitted).length == 0) {
                    return;
                }
                material = (Material)EnumUtil.valueOfSecure(Material.class, (String)splitted[0]);
            }
            if ((coordsSplitted = (coords = splitted == null ? linea : splitted[1]).split(",")).length < 3) {
                return;
            }
            double x = Double.parseDouble(coordsSplitted[0]);
            double y = Double.parseDouble(coordsSplitted[1]);
            double z = Double.parseDouble(coordsSplitted[2]);
            this.bloques.add(new BloqueEstructura(material, x, y, z));
        });
    }

    public void ejecutarEnCadaBloque(Location origen, BlockFace orientacion, BiConsumer<Block, Material> bloqueMinecraft) {
        World mundo = origen.getWorld();
        for (BloqueEstructura bloqueEstructura : this.bloques) {
            double x = bloqueEstructura.xRelativa;
            double y = bloqueEstructura.yRelativa;
            double z = bloqueEstructura.zRelativa;
            double finalX = 0.0;
            double finalZ = 0.0;
            switch (orientacion) {
                case NORTH: {
                    finalX = x;
                    finalZ = z;
                    break;
                }
                case SOUTH: {
                    finalX = x;
                    finalZ = z * -1.0;
                    break;
                }
                case WEST: {
                    finalX = z;
                    finalZ = x;
                    break;
                }
                case EAST: {
                    finalX = z * -1.0;
                    finalZ = x * -1.0;
                    break;
                }
            }
            Block block = mundo.getBlockAt(Ubicacion.getLocationWithOffset(origen, finalX, y, finalZ));
            bloqueMinecraft.accept(block, bloqueEstructura.bloque);
        }
    }

    public static class BloqueEstructura {
        public final Material bloque;
        public final double xRelativa;
        public final double yRelativa;
        public final double zRelativa;

        public BloqueEstructura(Material bloque, double xRelativa, double yRelativa, double zRelativa) {
            this.bloque = bloque;
            this.xRelativa = xRelativa;
            this.yRelativa = yRelativa;
            this.zRelativa = zRelativa;
        }
    }
}

