/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.core;

import es.pyronixstudio.base.core.PyronixPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class PyronixScheduler {
    public static PyronixTask runTaskTimer(long delay, long period, PyronixTaskRunnable pyronixRunnable) {
        PyronixTask task = PyronixTask.of(pyronixRunnable);
        task.runTaskTimer(delay, period);
        return task;
    }

    public static PyronixTask runTaskLater(long delay, PyronixTaskRunnable pyronixRunnable) {
        PyronixTask task = PyronixTask.of(pyronixRunnable);
        task.runTaskLater(delay);
        return task;
    }

    public static class PyronixTask {
        private final PyronixTaskRunnable pyronixTask;
        private BukkitTask bukkitTask;

        private static PyronixTask of(PyronixTaskRunnable pyronixTask) {
            return new PyronixTask(pyronixTask);
        }

        private PyronixTask(PyronixTaskRunnable pyronixTask) {
            this.pyronixTask = pyronixTask;
        }

        public void cancel() {
            if (this.bukkitTask == null || this.bukkitTask.isCancelled()) {
                return;
            }
            this.bukkitTask.cancel();
        }

        public boolean isCancelled() {
            return this.bukkitTask == null || this.bukkitTask.isCancelled();
        }

        private void runTaskTimer(long delay, long period) {
            BukkitRunnable runnable = this.createBukkitRunnable();
            this.bukkitTask = runnable.runTaskTimer(PyronixPlugin.INSTANCE, delay, period);
        }

        private void runTaskLater(long delay) {
            BukkitRunnable runnable = this.createBukkitRunnable();
            this.bukkitTask = runnable.runTaskLater(PyronixPlugin.INSTANCE, delay);
        }

        private BukkitRunnable createBukkitRunnable() {
            return new BukkitRunnable(){

                public void run() {
                    pyronixTask.run(this);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface PyronixTaskRunnable {
        public void run(PyronixTask var1);
    }
}

