/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.componentes;

public class Componente<T> {
    public final Class<T> clase;
    public final String id;

    protected Componente(String id, Class<T> clase) {
        this.id = id;
        this.clase = clase;
    }

    public static <U> Componente<U> newOf(String id, Class<U> clase) {
        return new Componente<U>(id, clase);
    }

    public int hashCode() {
        return this.clase.hashCode() + this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Componente) {
            Componente componente = (Componente)obj;
            return this.clase.equals(componente.clase) && this.id.equals(componente.id);
        }
        return false;
    }

    public String toString() {
        return String.format("{[Componente] Id:%s, Clase:%s}", this.id, this.clase.getSimpleName());
    }
}

