/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.puntuaciones;

import es.pyronixstudio.base.core.PyronixScheduler;
import es.pyronixstudio.base.juego.equipo.EnumColor;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.EnumEstadoPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.juego.puntuaciones.AbstractPuntuacion;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractPuntuacionManager<T extends AbstractPuntuacion>
implements IReseteable {
    protected Map<EnumColor, T> puntuaciones = new HashMap<EnumColor, T>();
    protected AbstractPartida<?, ?, ?> partida;
    private final boolean actulizarTrasSuma;
    protected PyronixScheduler.PyronixTask actualizarTask = null;

    public AbstractPuntuacionManager(AbstractPartida<?, ?, ?> partida, boolean actulizarTrasSuma) {
        this.partida = partida;
        this.actulizarTrasSuma = actulizarTrasSuma;
    }

    public void sumarActual(EnumColor color, int aSumar) {
        this.ejecutarSiExiste(color, puntuacion -> puntuacion.sumarActual(aSumar));
    }

    public void sumarGlobal(EnumColor color, int aSumar) {
        this.ejecutarSiExiste(color, puntuacion -> puntuacion.sumarGlobal(aSumar));
    }

    private T crearPuntuacionSiNoExiste(EnumColor color) {
        return (T)this.puntuaciones.computeIfAbsent(color, k -> (AbstractPuntuacion)this.getPuntuacionFactory().apply(color));
    }

    protected abstract Function<EnumColor, T> getPuntuacionFactory();

    protected abstract void actualizarUI();

    protected void programarActualizarUI(int ticks) {
        this.actualizarTask = PyronixScheduler.runTaskTimer(0L, ticks, task -> {
            if (this.partida.getEstado() == EnumEstadoPartida.TERMINADA) {
                task.cancel();
                return;
            }
            this.actualizarUI();
        });
    }

    private void ejecutarSiExiste(EnumColor color, Consumer<T> puntuacionEncontrada) {
        Objects.requireNonNull(color);
        T puntuacion = this.crearPuntuacionSiNoExiste(color);
        if (puntuacion != null) {
            puntuacionEncontrada.accept(puntuacion);
        }
        if (this.actulizarTrasSuma) {
            this.actualizarUI();
        }
    }

    public abstract void alIniciarPartida();

    public abstract void partidaTerminada();

    @Override
    public final boolean reset(AbstractPartida<?, ?, ?> partida) {
        this.resetExtra();
        if (this.actualizarTask != null) {
            this.actualizarTask.cancel();
        }
        for (AbstractPuntuacion puntuacion : this.puntuaciones.values()) {
            puntuacion.reset(partida);
        }
        return true;
    }

    protected abstract void resetExtra();

    @Override
    public void resetCompleto(AbstractPartida<?, ?, ?> partida) {
        this.puntuaciones.clear();
    }

    public String toString() {
        return String.format("{[AbstractPuntuacionManager] actualizarTask:%s, actulizarTrasSuma:%s, puntuaciones:%s}", this.actualizarTask, this.actulizarTrasSuma, this.puntuaciones);
    }
}

