/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.equipo;

import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.equipo.EnumColor;
import es.pyronixstudio.base.juego.equipo.PlayerInMoreThanOneTeamException;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.IManager;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public class EquipoManager<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
implements IManager<EnumColor, E> {
    private Map<EnumColor, E> teams = new HashMap<EnumColor, E>();

    public final E addIfNotExists(EnumColor color, Function<EnumColor, E> teamFactory) {
        return (E)this.teams.computeIfAbsent(color, k -> (AbstractEquipo)teamFactory.apply(color));
    }

    @Override
    public void add(EnumColor color, E team) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Wrapper<E> get(EnumColor color) {
        return Wrapper.of((Object)((AbstractEquipo)this.teams.get((Object)color)));
    }

    @Override
    public final Wrapper<E> get(UUID playerUUID) {
        Wrapper wrapper = Wrapper.emptyUnmodifiable();
        List<AbstractEquipo> equipos = this.filter(e -> {
            Iterator iterator = e.jugadores.iterator();
            if (iterator.hasNext()) {
                AbstractJugador jugador = (AbstractJugador)iterator.next();
                return jugador.getMinecraftPlayer().getUniqueId().equals(playerUUID);
            }
            return false;
        });
        if (equipos.size() > 1) {
            throw new PlayerInMoreThanOneTeamException(playerUUID);
        }
        if (!equipos.isEmpty()) {
            wrapper.set((Object)equipos.getFirst());
        }
        return wrapper;
    }

    @Override
    public Collection<E> getAll() {
        return this.teams.values();
    }

    @Override
    public Collection<EnumColor> getAllKeys() {
        return this.teams.keySet();
    }

    @Override
    public void remove(EnumColor color) {
        this.teams.remove((Object)color);
    }

    @Override
    public void removeAll() {
        this.teams.clear();
    }
}

