/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.entidades;

import es.pyronixstudio.base.juego.entidades.EntidadPersonalizada;
import es.pyronixstudio.base.juego.partida.IManager;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Entity;

public class EntityManager<E extends EntidadPersonalizada>
implements IManager<UUID, E> {
    private final Map<UUID, E> entities = new HashMap<UUID, E>();

    @Override
    public void add(UUID uuid, E customEntity) {
        this.entities.computeIfAbsent(uuid, k -> customEntity);
    }

    @Override
    public final Wrapper<E> get(Entity minecraftEntity) {
        if (minecraftEntity == null) {
            return Wrapper.empty();
        }
        return this.get(minecraftEntity.getUniqueId());
    }

    @Override
    public Wrapper<E> get(UUID uuid) {
        return Wrapper.of((Object)((EntidadPersonalizada)this.entities.get(uuid)));
    }

    @Override
    public Collection<E> getAll() {
        return this.entities.values();
    }

    @Override
    public Collection<UUID> getAllKeys() {
        return this.entities.keySet();
    }

    @Override
    public void remove(UUID uuid) {
        this.entities.remove(uuid);
    }

    @Override
    public void removeAll() {
        this.entities.clear();
    }
}

