/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.bloques;

import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.juego.bloques.IAccionBloque;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.EnumEstadoPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.base.util.Ubicacion;
import es.pyronixstudio.util.CastUtil;
import es.pyronixstudio.util.EnumUtil;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class BloquesManager<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
implements Listener,
IReseteable {
    private Map<Material, IAccionBloque<J, E, P>> bloques;
    private P partida;
    private int alturaDetecccion = -1;

    public BloquesManager(P partida) {
        this.partida = partida;
        this.bloques = RegistrosBase.ACCIONES_BLOQUES.getElementos(clave -> (Material)EnumUtil.valueOfSecure(Material.class, (String)clave), CastUtil::cast);
        PyronixPlugin.registrarEventos(this);
    }

    @EventHandler
    public final void onPlayerMoveEvent(PlayerMoveEvent event) {
        Location hacia;
        if (!((AbstractPartida)this.partida).getEstado().haSuperadoOEstaEnEstado(EnumEstadoPartida.INICIADA)) {
            return;
        }
        Location desde = event.getFrom();
        if (Ubicacion.esMismoBloque(desde, hacia = event.getTo())) {
            return;
        }
        ((AbstractPartida)this.partida).jugadorManager.get((Entity)event.getPlayer()).ifPresent(jugador -> {
            Location location = hacia.clone().add(0.0, (double)this.alturaDetecccion, 0.0);
            Material material = location.getBlock().getType();
            IAccionBloque<AbstractJugador, E, P> accion = this.bloques.get(material);
            if (accion != null) {
                accion.manejar((AbstractJugador)jugador, this.partida, location);
            }
        });
    }

    @Override
    public boolean reset(AbstractPartida<?, ?, ?> partida) {
        if (this.bloques != null) {
            this.bloques.values().forEach(IAccionBloque::reset);
        }
        PyronixPlugin.desregistrarEventos(this);
        return false;
    }
}

