/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.items;

import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.core.RutasBase;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.items.Accion;
import es.pyronixstudio.base.juego.items.IIntercambiable;
import es.pyronixstudio.base.juego.items.ItemPersonalizado;
import es.pyronixstudio.base.juego.items.ItemPersonalizadoLanzable;
import es.pyronixstudio.base.juego.items.contextos.ItemContextHandler;
import es.pyronixstudio.base.juego.items.contextos.ItemExecutionContext;
import es.pyronixstudio.base.juego.items.contextos.ItemHitContext;
import es.pyronixstudio.base.juego.items.contextos.ItemLaunchContext;
import es.pyronixstudio.base.juego.items.contextos.ItemUseContext;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.EnumEstadoPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistradorNameSpaceBase;
import es.pyronixstudio.base.sonido.SonidoBase;
import es.pyronixstudio.base.sonido.SonidoManager;
import es.pyronixstudio.base.util.EntityUtil;
import es.pyronixstudio.base.util.ItemStackUtil;
import es.pyronixstudio.util.CastUtil;
import es.pyronixstudio.util.ficheros.Elemento;
import es.pyronixstudio.util.ficheros.PyronixFile;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrowableProjectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;

public class ItemManager<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
implements Listener,
IReseteable {
    private Map<String, ItemPersonalizado> items = new HashMap<String, ItemPersonalizado>();
    private P partida;
    public final ItemContextHandler<J, E, P> contextHandler = new ItemContextHandler();

    public ItemManager(P partida) {
        this.partida = partida;
        this.cargarItems();
        PyronixPlugin.registrarEventos(this);
    }

    protected void cargarItems() {
        this.incluirItems(RutasBase.ITEMS_FICHERO, ItemPersonalizado::of);
    }

    protected void incluirItems(PyronixFile configItems, Function<Elemento, ItemPersonalizado> factory) {
        configItems.parsear();
        List idsItems = configItems.getIds();
        for (String idItem : idsItems) {
            this.items.put(idItem, factory.apply(configItems.getElemento(idItem)));
        }
    }

    public boolean darItem(String id, Player player, int cantidad, int invIndex) {
        Wrapper jugadorOpt = ((AbstractPartida)this.partida).jugadorManager.get(player);
        if (jugadorOpt.isPresent()) {
            return this.darItem(id, (AbstractJugador)jugadorOpt.get(), cantidad, invIndex);
        }
        return false;
    }

    public boolean darItem(String id, J jugador, int cantidad, int invIndex) {
        Wrapper<ItemPersonalizado> item = this.getItem(id);
        if (item.isPresent()) {
            this.darItem((ItemPersonalizado)item.get(), jugador, cantidad, invIndex);
            return true;
        }
        return false;
    }

    private void darItem(ItemPersonalizado itemObtenido, J jugador, int cantidad, int invIndex) {
        Wrapper stackWrapper = Wrapper.of((Object)itemObtenido.getItemStack());
        Accion<?, ?, ?> accion = itemObtenido.getAccion();
        if (accion instanceof IIntercambiable) {
            IIntercambiable intercambiable = (IIntercambiable)((Object)accion);
            intercambiable.transformar((Wrapper<ItemStack>)stackWrapper, itemObtenido, (AbstractJugador)CastUtil.cast(jugador));
            ItemStackUtil.setDataToItemStack((ItemStack)stackWrapper.get(), RegistradorNameSpaceBase.ITEMSTACK_TRANSFORMADO, PersistentDataType.BOOLEAN, Boolean.valueOf(true));
        }
        ItemStack stack = (ItemStack)stackWrapper.get();
        stack.setAmount(cantidad);
        Player player = ((AbstractJugador)jugador).getMinecraftPlayer();
        PlayerInventory inv = player.getInventory();
        if (invIndex >= 0) {
            inv.setItem(invIndex, stack);
        } else {
            inv.addItem(new ItemStack[]{stack});
        }
        itemObtenido.getAccion().onItemAddedToInventory(player);
        ((AbstractJugador)jugador).actualizarInv(this);
    }

    private void darItem(ItemPersonalizado itemObtenido, J jugador, int cantidad) {
        this.darItem(itemObtenido, jugador, cantidad, -1);
    }

    public boolean darItem(String id, Player player, int cantidad) {
        return this.darItem(id, player, cantidad, -1);
    }

    public boolean darItem(String id, J jugador, int cantidad) {
        return this.darItem(id, jugador, cantidad, -1);
    }

    public Wrapper<ItemPersonalizado> getItem(String id) {
        return Wrapper.of((Object)this.items.get(id));
    }

    public Wrapper<String> getItemIdFromNBT(ItemStack stack) {
        return Wrapper.of((Object)((String)ItemStackUtil.getDataFromItemStack(stack, RegistradorNameSpaceBase.ITEM_PERSONALIZADO_NAME_SPACE, PersistentDataType.STRING)));
    }

    public Set<String> getIds() {
        return this.items.keySet();
    }

    @EventHandler
    public void onInteractEvent(PlayerInteractEvent event) {
        Action accion = event.getAction();
        if (event.getHand() == EquipmentSlot.OFF_HAND || !((AbstractPartida)this.partida).getEstado().haSuperadoOEstaEnEstado(EnumEstadoPartida.INICIADA)) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemEnMano = player.getInventory().getItemInMainHand();
        ((AbstractPartida)this.partida).jugadorManager.get(player).ifPresent(jugador -> {
            ItemUseContext.EnumUseType useType = ItemUseContext.EnumUseType.fromBukkitType(accion);
            if (jugador.hasIgnoreLeftInteraction() && useType == ItemUseContext.EnumUseType.LEFT) {
                jugador.setIgnoreLeftInteraction(false);
                return;
            }
            String itemId = (String)this.getItemIdFromNBT(itemEnMano).get();
            if (itemId == null) {
                return;
            }
            ItemPersonalizado personalizado = (ItemPersonalizado)this.getItem(itemId).get();
            if (personalizado == null) {
                return;
            }
            ItemExecutionContext contexto = personalizado instanceof ItemPersonalizadoLanzable ? new ItemLaunchContext(this, (AbstractJugador)jugador, itemId, useType) : new ItemUseContext(this, (AbstractJugador)jugador, itemId, useType);
            contexto.itemStackInvJugador.set((Object)itemEnMano);
            contexto.dispatch();
        });
    }

    @EventHandler
    public void projectileHitEvent(ProjectileHitEvent event) {
        Projectile proyectil = event.getEntity();
        if (proyectil instanceof ThrowableProjectile) {
            ThrowableProjectile proyectilLanzable = (ThrowableProjectile)proyectil;
            ItemStack item = proyectilLanzable.getItem();
            if (item == null) {
                return;
            }
            ((AbstractPartida)this.partida).jugadorManager.get(EntityUtil.getShooter((Entity)proyectil).getUniqueId()).ifPresent(jugador -> {
                ItemUseContext.EnumUseType useType = EntityUtil.getEntityUseType(item);
                if (useType == null) {
                    return;
                }
                this.getItemIdFromNBT(item).ifPresent(itemId -> {
                    Entity hitEntity = event.getHitEntity();
                    Block hitBlock = event.getHitBlock();
                    ItemHitContext contexto = hitEntity != null ? new ItemHitContext(this, (AbstractJugador)jugador, (String)itemId, useType, proyectil, hitEntity) : new ItemHitContext(this, (AbstractJugador)jugador, (String)itemId, useType, proyectil, hitBlock, event.getHitBlockFace());
                    contexto.itemStackInvJugador.set((Object)item);
                    contexto.dispatch();
                });
            });
        }
    }

    @EventHandler
    public void onItemPickUpEvent(EntityPickupItemEvent event) {
        int cantidadItemInv;
        LivingEntity entidad = event.getEntity();
        Class<Player> clase = Player.class;
        if (entidad == null || !clase.isInstance(entidad)) {
            return;
        }
        Player player = (Player)clase.cast(entidad);
        Wrapper optJugador = ((AbstractPartida)this.partida).jugadorManager.get(player);
        if (optJugador.isEmpty()) {
            return;
        }
        AbstractJugador jugador = (AbstractJugador)optJugador.get();
        ItemStack stackSuelo = event.getItem().getItemStack();
        Wrapper<String> optItemId = this.getItemIdFromNBT(stackSuelo);
        if (optItemId.isEmpty()) {
            return;
        }
        String itemIDSuelo = (String)optItemId.get();
        ItemPersonalizado itemSueloPersonalizado = (ItemPersonalizado)this.getItem(itemIDSuelo).get();
        ItemPersonalizado itemInv = (ItemPersonalizado)jugador.getItem(itemIDSuelo).get();
        int n = cantidadItemInv = itemInv == null ? 0 : itemInv.getCantidad();
        if (jugador.isInvLleno()) {
            event.setCancelled(true);
            return;
        }
        if (cantidadItemInv < itemSueloPersonalizado.maxStack) {
            int faltaCantidad;
            int cantidadSuelo = stackSuelo.getAmount();
            if (cantidadSuelo > (faltaCantidad = itemSueloPersonalizado.maxStack - cantidadItemInv)) {
                stackSuelo.setAmount(cantidadSuelo - faltaCantidad);
                this.darItem(itemSueloPersonalizado, jugador, faltaCantidad);
            } else {
                stackSuelo.setAmount(0);
                this.darItem(itemSueloPersonalizado, jugador, cantidadSuelo);
            }
            SonidoManager.reproducirAudioEnMundo(player.getLocation(), SonidoBase.ofVanilla(Sound.ENTITY_ITEM_PICKUP), SoundCategory.PLAYERS, 0.2f, 2.0f);
            event.getItem().setItemStack(stackSuelo);
        }
        event.setCancelled(true);
    }

    @Override
    public boolean reset(AbstractPartida<?, ?, ?> partida) {
        PyronixPlugin.desregistrarEventos(this);
        return false;
    }
}

