/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.areas;

import es.pyronixstudio.base.core.PyronixScheduler;
import es.pyronixstudio.base.juego.areas.Area;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.mapa.AbstractMapa;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.EnumEstadoPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.util.CastUtil;
import es.pyronixstudio.util.Logger;
import es.pyronixstudio.util.ficheros.Elemento;
import es.pyronixstudio.util.ficheros.Valor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AreasManager<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
extends BukkitRunnable
implements IReseteable {
    private P partida;
    private Map<Location, Area<J, E, P>> areas = new ConcurrentHashMap<Location, Area<J, E, P>>();

    public AreasManager(P partida) {
        this.partida = partida;
        this.runTaskTimer((Plugin)((AbstractPartida)partida).plugin, 0L, 10L);
        AbstractMapa mapa = (AbstractMapa)((AbstractPartida)partida).componentSystem.get(RegistrosBase.COMPONENTES.MAPA);
        if (mapa != null) {
            mapa.marcadores.ejecutarEnTipo(RegistrosBase.TIPO_MARCADORES.AREA, marcadorArea -> {
                Elemento config = marcadorArea.config;
                int area = config.getOrDefault("area", (Object)1).asInt();
                Area.newBuilder(RegistrosBase.CREADOR_AREAS.get(marcadorArea.config.get("accion")), partida).ifPresent(builder -> {
                    Valor args = config.getOrDefault("args", (Object)new Valor[0]);
                    marcadorArea.getUbicaciones().forEach(ubicacion -> this.add((Location)ubicacion, area, (Area.Builder)builder, args));
                });
            });
        }
    }

    public void add(Location location, int area, Area.Builder builder, Valor args) {
        builder.setCentro(location);
        builder.set(area);
        builder.args(args.asArray());
        this.add(builder);
    }

    public void add(Area.Builder builder) {
        builder.setAreaManager(this);
        Area<?, ?, ?> area = builder.build();
        int maxTicks = area.maxTicks;
        if (maxTicks != -1) {
            PyronixScheduler.runTaskLater(maxTicks, task -> area.desregistrar());
        }
        this.areas.put(area.centro, (Area)CastUtil.cast(area));
    }

    public void remove(Location centro) {
        Area<J, E, P> area = this.areas.remove(centro);
        if (area != null) {
            area.alDesregistrarse();
        }
    }

    public void run() {
        if (!((AbstractPartida)this.partida).getEstado().haSuperadoOEstaEnEstado(EnumEstadoPartida.INICIADA)) {
            return;
        }
        if (this.areas.isEmpty()) {
            return;
        }
        for (Area<J, E, P> area : this.areas.values()) {
            try {
                area.comprobarColisiones();
            }
            catch (Exception e) {
                Logger.severe((String)"Ocurrio un error en un Area %s", (Object[])new Object[]{area.getClass().getSimpleName()});
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean reset(AbstractPartida<?, ?, ?> partida) {
        this.cancel();
        this.areas.values().forEach(area -> {
            Entity trackedEntity = (Entity)area.componentSystem.get(RegistrosBase.COMPONENTES.ENTIDAD_TRACKEADA_AREA);
            if (trackedEntity instanceof Player) {
                return;
            }
            if (trackedEntity != null && trackedEntity.isValid()) {
                trackedEntity.remove();
            }
        });
        this.areas.clear();
        return false;
    }
}

