/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.mapa.serializador;

import es.pyronixstudio.base.juego.mapa.serializador.BiselectedHandler;
import es.pyronixstudio.base.juego.mapa.serializador.DirectionalHandler;
import es.pyronixstudio.base.juego.mapa.serializador.IBloqueHandler;
import es.pyronixstudio.base.juego.mapa.serializador.OrientableHandler;
import es.pyronixstudio.base.juego.mapa.serializador.RotatableHandler;
import es.pyronixstudio.base.juego.mapa.serializador.SlabHandler;
import es.pyronixstudio.base.juego.mapa.serializador.StairsHandler;
import es.pyronixstudio.base.juego.mapa.serializador.WallHandler;
import es.pyronixstudio.base.juego.mapa.serializador.WaterLoggedHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;

public class SerializadorBloqueManager {
    private final List<IBloqueHandler<?>> registro = List.of(new DirectionalHandler(), new OrientableHandler(), new RotatableHandler(), new BiselectedHandler(), new WaterLoggedHandler(), new StairsHandler(), new SlabHandler(), new WallHandler());

    public void serializar(List<String> lineasFichero, Block block) {
        ArrayList<Object> linea = new ArrayList<Object>();
        BlockData data = block.getBlockData();
        linea.add(block.getType().name());
        linea.add(block.getX());
        linea.add(block.getY());
        linea.add(block.getZ());
        for (IBloqueHandler<?> handler : this.registro) {
            handler.serializarSeguro(data, linea);
        }
        String resultado = linea.stream().map(Object::toString).collect(Collectors.joining(","));
        lineasFichero.add(resultado);
    }

    public void deserializar(String linea, World world, Material bloqueQueSeQuiere) {
        String[] args = linea.split(",");
        int indice = 0;
        Material material = Material.valueOf((String)args[indice++].toUpperCase());
        if (bloqueQueSeQuiere != null) {
            material = bloqueQueSeQuiere;
        }
        int x = Integer.parseInt(args[indice++]);
        int y = Integer.parseInt(args[indice++]);
        int z = Integer.parseInt(args[indice++]);
        Block block = world.getBlockAt(x, y, z);
        block.setType(material);
        BlockData data = block.getBlockData();
        for (IBloqueHandler<?> handler : this.registro) {
            if (args.length == indice) break;
            if (!handler.isInstance(data)) continue;
            int numParametros = handler.getParametersNumber();
            String[] parametros = new String[numParametros];
            for (int i = 0; i < parametros.length; ++i) {
                parametros[i] = args[indice++];
            }
            handler.deserializarSeguro(data, parametros);
        }
        block.setBlockData(data);
    }

    public void copiarDatos(BlockData original, BlockData to) {
        for (IBloqueHandler<?> handler : this.registro) {
            handler.copiarSeguro(original, to);
        }
    }
}

