/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.comandos.base;

import es.pyronixstudio.base.comandos.AbstractComandoBasePartida;
import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.EnumEstadoPartida;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public abstract class AbstractComandoEquiposBase<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
extends AbstractComandoBasePartida<J, E, P> {
    public AbstractComandoEquiposBase(PyronixPlugin<J, E, P> plugin) {
        super(true, plugin);
    }

    @Override
    protected List<String> autoCompletarExtra(CommandSender sender, Command command, String label, Wrapper<Integer> id, List<String> args) {
        if (args.size() == 0) {
            return null;
        }
        ArrayList<String> devolver = new ArrayList<String>();
        Wrapper partidaOptional = this.plugin.partidaManager.get(id);
        if (partidaOptional.isPresent()) {
            AbstractPartida partida = (AbstractPartida)partidaOptional.get();
            if (partida.getEstado().haSuperadoOEstaEnEstado(EnumEstadoPartida.PRE_INICIALIZADA)) {
                devolver.addAll(List.of("asignar"));
            }
            devolver.addAll(List.of("listar", "reset"));
        }
        return devolver;
    }

    @Override
    protected void onCommandExtra(CommandSender sender, String label, Wrapper<Integer> idOptional, List<String> args) {
        int size = args.size();
        int id = (Integer)idOptional.getOrDefault((Object)0);
        Wrapper partidaOptional = this.plugin.partidaManager.get(idOptional);
        if (partidaOptional.isEmpty()) {
            this.enviarMensaje(String.format("<red>No hay ninguna partida creada con el ID: <gold>%s", id), sender);
            return;
        }
        if (size == 0) {
            this.enviarMensaje(String.format("<red>Uso del comando: /%s <listar,asignar,reset>", label), sender);
            return;
        }
        String subComando = args.get(0);
        AbstractPartida partida = (AbstractPartida)partidaOptional.get();
        if (subComando.equals("asignar")) {
            partida.meterJugadoresAEquipo();
            this.enviarMensaje("<green>Se asigno a los jugadores a los equipos correspondientes.", sender);
            return;
        }
        if (subComando.equals("listar")) {
            Collection equipos = partida.equipoManager.getAll();
            StringBuilder stringBuilder = new StringBuilder();
            for (AbstractEquipo equipo : equipos) {
                stringBuilder.append(String.format("<gold>#Equipo: %s\n", equipo.getColor().toString().toLowerCase()));
                for (AbstractJugador jugador : equipo.getJugadores()) {
                    stringBuilder.append(String.format("<blue>-%s\n", jugador.getMinecraftPlayer().getName()));
                }
                stringBuilder.append("\n");
            }
            if (equipos.size() == 0) {
                this.enviarMensaje(String.format("<red>No hay ningun equipo en la partida con el ID: <gold>%s", id), sender);
                return;
            }
            this.enviarMensaje(String.format("<green>Aqui se muestran los equipos y sus jugadores:\n%s", stringBuilder.toString()), sender);
            return;
        }
        if (subComando.equals("reset")) {
            if (partida.getEstado().haSuperadoOEstaEnEstado(EnumEstadoPartida.INICIADA)) {
                this.enviarMensaje(String.format("<red>La partida con el ID: <gold>%s <red>esta iniciada no puedes borrar equipos durante una partida", id), sender);
                return;
            }
            if (partida.equipoManager.getAll().isEmpty()) {
                this.enviarMensaje(String.format("<red>En la partida con el ID: <gold>%s <red>no hay equipos", id), sender);
                return;
            }
            this.enviarMensaje(String.format("<green>Equipos reseteados para la partida con el ID: <gold>%s", id), sender);
            partida.borrarEquipos();
            return;
        }
    }
}

