/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.areas;

import com.destroystokyo.paper.ParticleBuilder;
import es.pyronixstudio.base.juego.ITickable;
import es.pyronixstudio.base.juego.areas.Area;
import es.pyronixstudio.base.util.Ubicacion;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;

public abstract class BaseParticulasHelperAreas
implements ITickable {
    protected final Area<?, ?, ?> area;
    protected final ParticleBuilder particle;
    protected final double offsetY;
    protected final double centerOffsetXZ;
    protected final double paso;
    protected Ubicacion.EsquinasLocationRecord esquinas;
    protected List<Location> bloques = new ArrayList<Location>();

    public BaseParticulasHelperAreas(Area<?, ?, ?> area, ParticleBuilder particles, double offsetY) {
        this(area, particles, offsetY, 0.5, 0.4);
    }

    public BaseParticulasHelperAreas(Area<?, ?, ?> area, ParticleBuilder particles, double offsetY, double centerOffsetXZ, double paso) {
        this.area = area;
        this.particle = particles;
        this.offsetY = offsetY;
        this.centerOffsetXZ = centerOffsetXZ;
        this.paso = paso;
        this.update();
    }

    public void update() {
        this.calcularPuntos();
    }

    @Override
    public void tick() {
        for (Location bloque : this.bloques) {
            this.particle.location(bloque).spawn();
        }
    }

    protected abstract void calcularPuntos();

    protected List<Location> generarLineaHorizontal(double x1, double z1, double x2, double z2, double y) {
        ArrayList<Location> resultado = new ArrayList<Location>();
        double dx = x2 - x1;
        double dz = z2 - z1;
        double distancia = Math.sqrt(dx * dx + dz * dz);
        int pasos = Math.max(1, (int)(distancia / this.paso));
        for (int i = 0; i <= pasos; ++i) {
            double factor = (double)i / (double)pasos;
            double x = x1 + dx * factor + this.centerOffsetXZ;
            double z = z1 + dz * factor + this.centerOffsetXZ;
            resultado.add(new Location(this.esquinas.world, x, y + this.offsetY, z));
        }
        return resultado;
    }

    protected List<Location> generarLineaVertical(double x, double z, double y1, double y2) {
        ArrayList<Location> resultado = new ArrayList<Location>();
        double dy = y2 - y1;
        double distancia = Math.abs(dy);
        int pasos = Math.max(1, (int)(distancia / this.paso));
        for (int i = 0; i <= pasos; ++i) {
            double factor = (double)i / (double)pasos;
            double y = y1 + dy * factor;
            resultado.add(new Location(this.esquinas.world, x + this.centerOffsetXZ, y + this.offsetY, z + this.centerOffsetXZ));
        }
        return resultado;
    }
}

