/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.mapa.generadores;

import es.pyronixstudio.base.juego.items.ItemPersonalizado;
import es.pyronixstudio.base.util.Ubicacion;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.util.Vector;

public interface IGenerado {
    public boolean sigueExistiendo();

    public Location getLocation();

    public void reset();

    public void init();

    public static class GeneradoBloque
    implements IGenerado {
        public final Location location;
        public final Material material;
        public final Block block;
        public final Material bloqueReset;

        public static GeneradoBloque of(Ubicacion.BlockLocation location, Material material, Material bloqueReset) {
            GeneradoBloque generadoBloque = new GeneradoBloque(location, material, bloqueReset);
            generadoBloque.init();
            return generadoBloque;
        }

        private GeneradoBloque(Ubicacion.BlockLocation location, Material material, Material bloqueReset) {
            this.location = location.getMinecraftLocation();
            this.block = this.location.getBlock();
            this.material = material;
            this.bloqueReset = bloqueReset;
        }

        @Override
        public void init() {
            this.setMaterial(this.material);
        }

        private void setMaterial(Material material) {
            this.block.setType(material);
        }

        @Override
        public boolean sigueExistiendo() {
            return this.getType() == this.material;
        }

        private Material getType() {
            return this.block.getType();
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public void reset() {
            this.setMaterial(this.bloqueReset);
        }

        public String toString() {
            return this.material.name();
        }
    }

    public static class GeneradoItem
    extends GeneradoEntidad {
        private final ItemPersonalizado item;

        public static GeneradoItem of(Ubicacion.BlockLocation location, ItemPersonalizado item) {
            GeneradoItem generadoItem = new GeneradoItem(location, item);
            generadoItem.init();
            return generadoItem;
        }

        private GeneradoItem(Ubicacion.BlockLocation location, ItemPersonalizado item) {
            super(location);
            this.item = item;
        }

        @Override
        protected Entity generar(EntityType tipo) {
            World world = this.location.getWorld();
            Item entityItem = world.dropItem(this.location, this.item.getItemStack());
            return entityItem;
        }
    }

    public static class GeneradoEntidad
    implements IGenerado {
        protected Entity entity;
        protected final Location location;

        public static GeneradoEntidad of(Entity entity, Ubicacion.BlockLocation location) {
            GeneradoEntidad generadoEntidad = new GeneradoEntidad(entity, location);
            generadoEntidad.init();
            return generadoEntidad;
        }

        public GeneradoEntidad(Ubicacion.BlockLocation location) {
            this(null, location);
        }

        private GeneradoEntidad(Entity entity, Ubicacion.BlockLocation location) {
            this.location = location.getMinecraftLocation().add(0.5, 0.0, 0.5);
        }

        @Override
        public void init() {
            EntityType type = this.entity == null ? null : this.entity.getType();
            this.entity = this.generar(type);
            this.aplicarVectorY();
        }

        @Override
        public boolean sigueExistiendo() {
            return this.entity.isValid();
        }

        @Override
        public Location getLocation() {
            return this.entity.getLocation();
        }

        @Override
        public void reset() {
            this.entity.remove();
        }

        public String toString() {
            return this.entity.toString();
        }

        protected Entity generar(EntityType tipo) {
            return null;
        }

        private void aplicarVectorY() {
            this.entity.setVelocity(new Vector(0.0, 0.3, 0.0));
        }
    }
}

