/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.items;

import java.util.EnumSet;
import java.util.Set;

public class EstadoEjecuccion {
    private Set<EnumEstadoEjecuccion> estados = EnumSet.noneOf(EnumEstadoEjecuccion.class);

    public static EstadoEjecuccion create() {
        return new EstadoEjecuccion();
    }

    public void setOK() {
        this.estados.add(EnumEstadoEjecuccion.OK);
    }

    public void setNoConsumir() {
        this.estados.add(EnumEstadoEjecuccion.NO_CONSUMIR);
    }

    public void setError() {
        this.estados.add(EnumEstadoEjecuccion.ERROR);
    }

    public void setNoProcesar() {
        this.estados.add(EnumEstadoEjecuccion.NO_PROCESAR);
    }

    public boolean isOk() {
        return this.contiene(EnumEstadoEjecuccion.OK);
    }

    public boolean isNoConsumir() {
        return this.contiene(EnumEstadoEjecuccion.NO_CONSUMIR);
    }

    public boolean isError() {
        return this.contiene(EnumEstadoEjecuccion.ERROR);
    }

    public boolean isNoProcesar() {
        return this.contiene(EnumEstadoEjecuccion.NO_PROCESAR);
    }

    private boolean contiene(EnumEstadoEjecuccion estado) {
        return this.estados.contains((Object)estado);
    }

    public boolean isEmpty() {
        return this.estados.isEmpty();
    }

    public String toString() {
        return String.format("{[EstadoEjecuccion] %s}", this.estados.toString());
    }

    public static enum EnumEstadoEjecuccion {
        OK,
        NO_CONSUMIR,
        ERROR,
        NO_PROCESAR;

    }
}

