/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.eventos;

import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.eventos.AbstractEvento;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class EventosManager {
    private final PyronixPlugin plugin;
    private final Map<Class<? extends AbstractEvento>, List<Consumer<AbstractEvento>>> eventos = new HashMap<Class<? extends AbstractEvento>, List<Consumer<AbstractEvento>>>();

    public EventosManager(PyronixPlugin plugin) {
        this.plugin = plugin;
    }

    public <T extends AbstractEvento> void emitirEvento(T evento) {
        List<Consumer<AbstractEvento>> lista = this.eventos.get(evento.getClass());
        if (lista == null) {
            return;
        }
        List.copyOf(lista).forEach(consumidor -> consumidor.accept(evento));
    }

    public <T extends AbstractEvento> void agregarEscuchador(Class<T> clase, Consumer<T> eventoConsumer) {
        this.eventos.computeIfAbsent(clase, k -> new ArrayList()).add(evento -> eventoConsumer.accept((AbstractEvento)clase.cast(evento)));
    }
}

