/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.util;

import es.pyronixstudio.util.ficheros.Elemento;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class Ubicacion {
    private static BiFunction<String, String, String> formato = (subFix, letra) -> String.format("%s%s", letra, subFix == null ? "" : subFix);

    public static Location getLocation(Elemento elemento) {
        return Ubicacion.getLocation(elemento, null);
    }

    public static Location getLocation(World world, int desde, List<String> args) {
        Elemento ubicacion = Elemento.empty((String)"");
        ubicacion.add("x", (Object)args.get(desde++));
        ubicacion.add("y", (Object)args.get(desde++));
        ubicacion.add("z", (Object)args.get(desde++));
        ubicacion.add("mundo", (Object)world.getName());
        return Ubicacion.getLocation(ubicacion);
    }

    public static Location getLocation(Elemento elemento, String subFix) {
        return Ubicacion.getLocation((World)elemento.get("mundo").asCustom(Bukkit::getWorld), elemento, subFix);
    }

    public static Location getLocation(World world, Elemento elemento, String subFix) {
        int x = elemento.get(formato.apply(subFix, "x")).asInt();
        int y = elemento.get(formato.apply(subFix, "y")).asInt();
        int z = elemento.get(formato.apply(subFix, "z")).asInt();
        return new Location(world, (double)x, (double)y, (double)z);
    }

    public static Location getLocation(World world, String coords, String split) {
        String[] splitted = coords.split(split);
        double x = Double.parseDouble(splitted[0]);
        double y = Double.parseDouble(splitted[1]);
        double z = Double.parseDouble(splitted[2]);
        return new Location(world, x, y, z);
    }

    public static Location getLocation(World world, String coords) {
        return Ubicacion.getLocation(world, coords, ",");
    }

    public static Location getLocationWithOffset(Location original, double xOffset, double yOffset, double zOffset) {
        return new Location(original.getWorld(), (double)original.getBlockX() + xOffset, (double)original.getBlockY() + yOffset, (double)original.getBlockZ() + zOffset);
    }

    public static EsquinasLocationRecord getLocacionCoordsMenorMayor(Location location1, Location location2) {
        int minX = (int)Math.min(location1.getX(), location2.getX());
        int minY = (int)Math.min(location1.getY(), location2.getY());
        int minZ = (int)Math.min(location1.getZ(), location2.getZ());
        int maxX = (int)Math.max(location1.getX(), location2.getX());
        int maxY = (int)Math.max(location1.getY(), location2.getY());
        int maxZ = (int)Math.max(location1.getZ(), location2.getZ());
        return new EsquinasLocationRecord(minX, minY, minZ, maxX, maxY, maxZ, location1.getWorld());
    }

    public static EsquinasLocationRecord getEsquinarRelativa(Location centro, int areaX, int areaY, int areaZ) {
        World world = centro.getWorld();
        Location esquina1 = new Location(world, (double)(centro.getBlockX() + areaX), (double)(centro.getBlockY() + areaY), (double)(centro.getBlockZ() + areaZ));
        Location esquina2 = new Location(world, (double)(centro.getBlockX() - areaX), (double)(centro.getBlockY() - areaY), (double)(centro.getBlockZ() - areaZ));
        return Ubicacion.getLocacionCoordsMenorMayor(esquina1, esquina2);
    }

    public static Location mitad(Location ubicacion1, Location ubicacion2) {
        int x = ubicacion1.getBlockX();
        int y = ubicacion1.getBlockY();
        int z = ubicacion1.getBlockZ();
        int x2 = ubicacion2.getBlockX();
        int y2 = ubicacion2.getBlockY();
        int z2 = ubicacion2.getBlockZ();
        int xFinal = Ubicacion.dividirSiNoEs0(x + x2, 2);
        int yFinal = Ubicacion.dividirSiNoEs0(y + y2, 2);
        int zFinal = Ubicacion.dividirSiNoEs0(z + z2, 2);
        return new Location(ubicacion1.getWorld(), (double)xFinal, (double)yFinal, (double)zFinal);
    }

    private static int dividirSiNoEs0(int dividendo, int divisor) {
        if (dividendo == 0 || divisor == 0) {
            return 0;
        }
        return dividendo / divisor;
    }

    public static void escribir(Elemento elemento, Location ubicacion) {
        Ubicacion.escribir(elemento, ubicacion, null, false);
    }

    public static void escribir(Elemento elemento, Location ubicacion, boolean ponerMundo) {
        Ubicacion.escribir(elemento, ubicacion, null, ponerMundo);
    }

    public static void escribir(Elemento elemento, Location ubicacion, String prefix) {
        Ubicacion.escribir(elemento, ubicacion, prefix, false);
    }

    public static void escribir(Elemento elemento, Location ubicacion, String prefix, boolean ponerMundo) {
        if (ponerMundo) {
            elemento.add("mundo", (Object)ubicacion.getWorld().getName());
        }
        elemento.add(formato.apply(prefix, "x"), (Object)ubicacion.getBlockX());
        elemento.add(formato.apply(prefix, "y"), (Object)ubicacion.getBlockY());
        elemento.add(formato.apply(prefix, "z"), (Object)ubicacion.getBlockZ());
    }

    public static boolean esMismoBloque(Location from, Location to) {
        int xf = from.getBlockX();
        int yf = from.getBlockY();
        int zf = from.getBlockZ();
        int xt = to.getBlockX();
        int yt = to.getBlockY();
        int zt = to.getBlockZ();
        return xf == xt && yf == yt && zf == zt;
    }

    public static class EsquinasLocationRecord {
        public final int menorX;
        public final int menorY;
        public final int menorZ;
        public final int maxX;
        public final int maxY;
        public final int maxZ;
        public final World world;

        public EsquinasLocationRecord(int menorX, int menorY, int menorZ, int maxX, int maxY, int maxZ, World world) {
            this.menorX = menorX;
            this.menorY = menorY;
            this.menorZ = menorZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
            this.world = world;
        }

        public Location getMayor() {
            return new Location(this.world, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
        }

        public Location getMenor() {
            return new Location(this.world, (double)this.menorX, (double)this.menorY, (double)this.menorZ);
        }

        public String toString() {
            return "EsquinasLocationRecord [menorX=" + this.menorX + ", menorY=" + this.menorY + ", menorZ=" + this.menorZ + ", maxX=" + this.maxX + ", maxY=" + this.maxY + ", maxZ=" + this.maxZ + ", world=" + this.world.getName() + "]";
        }
    }

    public static class WorldLocation {
        public final double x;
        public final double y;
        public final double z;
        public final UUID worldID;

        public static WorldLocation fromBukkit(Location location) {
            Objects.requireNonNull(location);
            return new WorldLocation(location);
        }

        public static WorldLocation from(double x, double y, double z) {
            return new WorldLocation(x, y, z);
        }

        protected WorldLocation(Location bukkitLocation) {
            this.x = bukkitLocation.getBlockX();
            this.y = bukkitLocation.getBlockY();
            this.z = bukkitLocation.getBlockZ();
            this.worldID = bukkitLocation.getWorld().getUID();
        }

        protected WorldLocation(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.worldID = null;
        }

        public final Location getMinecraftLocation() {
            World world = Bukkit.getWorld((UUID)this.worldID);
            return new Location(world, this.x, this.y, this.z);
        }
    }

    public static class BlockLocation {
        public final int x;
        public final int y;
        public final int z;
        public final UUID worldID;

        public static BlockLocation fromBukkit(Location location) {
            Objects.requireNonNull(location);
            return new BlockLocation(location);
        }

        public static BlockLocation from(int x, int y, int z) {
            return new BlockLocation(x, y, z);
        }

        protected BlockLocation(Location bukkitLocation) {
            this.x = bukkitLocation.getBlockX();
            this.y = bukkitLocation.getBlockY();
            this.z = bukkitLocation.getBlockZ();
            this.worldID = bukkitLocation.getWorld().getUID();
        }

        protected BlockLocation(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.worldID = null;
        }

        public int hashCode() {
            int hash = 0;
            hash += Integer.hashCode(this.x);
            hash += Integer.hashCode(this.y);
            hash += Integer.hashCode(this.z);
            return hash += this.worldID.hashCode();
        }

        public final Location getMinecraftLocation() {
            World world = Bukkit.getWorld((UUID)this.worldID);
            return new Location(world, (double)this.x, (double)this.y, (double)this.z);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof BlockLocation) {
                BlockLocation otroLocation = (BlockLocation)obj;
                return this.x == otroLocation.x && this.y == otroLocation.y && this.z == otroLocation.z && this.worldID.equals(otroLocation.worldID);
            }
            return false;
        }
    }
}

