/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.registros.tipo;

import es.pyronixstudio.base.registros.tipo.IRegistro;
import java.util.function.Function;
import java.util.function.Supplier;

public class Registro<T>
implements IRegistro<T> {
    private final Supplier<T> supplier;

    public static <T> IRegistro<T> empty() {
        return Registro.of(null);
    }

    public static <T> IRegistro<T> of(Supplier<T> supplier) {
        return new Registro<T>(supplier);
    }

    public static <T, U> IRegistro<T> of(U objetoConstructor, Function<U, T> funcion) {
        return new Registro<Object>(() -> funcion.apply(objetoConstructor));
    }

    public static <T> IRegistro<T> forVanilla(T vanillaObject) {
        return Registro.of(() -> vanillaObject);
    }

    private Registro(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public boolean isEmpty() {
        return this.supplier == null;
    }

    public T get() {
        return this.supplier.get();
    }
}

