/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.partida;

import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.EnumEstadoPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.juego.partida.jugador.JugadorManager;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.base.registros.tipo.IRegistro;
import es.pyronixstudio.base.sonido.SonidoBase;
import es.pyronixstudio.base.sonido.SonidoManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class CuentaAtras
extends BukkitRunnable
implements IReseteable {
    private static final Map<AbstractPartida<?, ?, ?>, List<BukkitTask>> tareasCuentasAtras = new HashMap();
    private final int maximoCuenta = 6;
    private int cuenta = 6;
    private final AbstractPartida<?, ?, ?> partida;
    private final JugadorManager<?, ?, ?> jugadorManager;
    private final Runnable alTerminar;
    private final String[] color = new String[]{"<green>", "<blue>", "<gray>", "<gold>", "<light_purple>"};
    private final int delayEntreEjecuciones = 29;
    private final IRegistro<SonidoBase> sonidoAJugar;
    private BukkitTask tarea;

    private static void alBorrarUnaPartida(AbstractPartida<?, ?, ?> partida) {
        CuentaAtras.cancelarTodas(partida);
        tareasCuentasAtras.remove(partida);
    }

    private static void cancelarTodas(AbstractPartida<?, ?, ?> partida) {
        List<BukkitTask> tareas = tareasCuentasAtras.get(partida);
        if (tareas != null) {
            List.copyOf(tareas).forEach(tarea -> CuentaAtras.borrarTarea(partida, tarea));
        }
    }

    private static void borrarTarea(AbstractPartida<?, ?, ?> partida, BukkitTask tarea) {
        List<BukkitTask> tareas = tareasCuentasAtras.get(partida);
        if (tareas != null) {
            tarea.cancel();
            tareas.remove(tarea);
        }
    }

    public static void nuevaCuentaAtras(AbstractPartida<?, ?, ?> partida, Runnable alTerminar, IRegistro<SonidoBase> sonidoAJugar) {
        CuentaAtras.nuevaCuentaAtras(partida, alTerminar, 5, sonidoAJugar);
    }

    public static void nuevaCuentaAtras(AbstractPartida<?, ?, ?> partida, Runnable alTerminar, int delayAntesDeEjecucion, IRegistro<SonidoBase> sonidoAJugar) {
        partida.resetManager.agregarObjeto(new CuentaAtras(partida, alTerminar, delayAntesDeEjecucion, sonidoAJugar));
    }

    private CuentaAtras(AbstractPartida<?, ?, ?> partida, Runnable alTerminar, int delayAntesDeEjecucion, IRegistro<SonidoBase> sonidoAJugar) {
        this.partida = partida;
        this.jugadorManager = partida.jugadorManager;
        this.alTerminar = alTerminar;
        this.sonidoAJugar = sonidoAJugar;
        partida.setEstado(EnumEstadoPartida.INICIANDO);
        if (partida.getEstado().haSuperadoOEstaEnEstado(EnumEstadoPartida.CREADA)) {
            this.tarea = this.runTaskTimer((Plugin)PyronixPlugin.INSTANCE, (long)delayAntesDeEjecucion * 20L, 29L);
            tareasCuentasAtras.computeIfAbsent(partida, k -> new ArrayList()).add(this.tarea);
        }
    }

    public void run() {
        if (this.isCancelled()) {
            CuentaAtras.borrarTarea(this.partida, this.tarea);
            return;
        }
        if (this.cuenta != 6) {
            if (this.cuenta == 0) {
                this.partida.setEstado(EnumEstadoPartida.INICIADA);
                this.partida.enviarTitulo("<gold>A Jugar!", "", 500, 1500, 500);
                SonidoManager.reproducirAudioATodosEnPartida(this.jugadorManager, this.sonidoAJugar, 1.0f, 1.0f);
                if (this.alTerminar != null) {
                    this.alTerminar.run();
                }
                CuentaAtras.borrarTarea(this.partida, this.tarea);
            }
            if (!this.isCancelled()) {
                String numero = String.format("%s%s", this.color[this.cuenta - 1], this.cuenta);
                SonidoManager.reproducirAudioATodosEnPartida(this.jugadorManager, RegistrosBase.SONIDOS.get(this.cuenta), 1.0f, 1.0f);
                this.partida.enviarTitulo(numero, "", 250, 950, 250);
            }
        } else {
            SonidoManager.reproducirAudioATodosEnPartida(this.jugadorManager, RegistrosBase.SONIDOS.COMENZANDO_EN, 1.0f, 1.0f);
            this.partida.enviarTitulo("<red>Empezando en...", "", 350, 1000, 100);
        }
        --this.cuenta;
    }

    @Override
    public boolean reset(AbstractPartida<?, ?, ?> partida) {
        CuentaAtras.cancelarTodas(partida);
        return false;
    }

    @Override
    public void resetCompleto(AbstractPartida<?, ?, ?> partida) {
        CuentaAtras.alBorrarUnaPartida(partida);
    }
}

