/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.estructuras;

import es.pyronixstudio.base.util.BlockReference;
import es.pyronixstudio.base.util.Ubicacion;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class Estructura {
    private EstructuraGenerada generada;
    protected String id;

    public Estructura(String id) {
        this.id = id;
    }

    public EstructuraGenerada generar(List<String> patron, Location location, BlockFace orientacion) {
        return this.generar(patron, location, orientacion, null, false);
    }

    public EstructuraGenerada generar(List<String> patron, Location location, BlockFace orientacion, Set<Material> materilesPermitidos, boolean force) {
        this.generada = EstructuraGenerada.create();
        for (String linea : patron) {
            boolean tipoValido;
            String[] lineaSplitted;
            if (linea.isEmpty() || linea.isBlank() || (lineaSplitted = linea.split(":")).length == 0) continue;
            Material bloque = Material.matchMaterial((String)lineaSplitted[0]);
            String coordenadasJuntas = lineaSplitted[1];
            String[] coordsSplitted = coordenadasJuntas.split(",");
            if (coordsSplitted.length < 3) continue;
            double x = Double.parseDouble(coordsSplitted[0]);
            double y = Double.parseDouble(coordsSplitted[1]);
            double z = Double.parseDouble(coordsSplitted[2]);
            double finalX = 0.0;
            double finalZ = 0.0;
            switch (orientacion) {
                case NORTH: {
                    finalX = x;
                    finalZ = z;
                    break;
                }
                case SOUTH: {
                    finalX = x;
                    finalZ = z * -1.0;
                    break;
                }
                case WEST: {
                    finalX = z;
                    finalZ = x;
                    break;
                }
                case EAST: {
                    finalX = z * -1.0;
                    finalZ = x * -1.0;
                    break;
                }
            }
            World world = location.getWorld();
            Block block = world.getBlockAt(Ubicacion.getLocationWithOffset(location, finalX, y, finalZ));
            Material tipo = block.getType();
            boolean bl = force ? false : (tipoValido = tipo != Material.AIR);
            if (tipoValido && (materilesPermitidos == null || !materilesPermitidos.contains(tipo))) continue;
            this.generada.add(block);
            block.setType(bloque);
        }
        return this.generada;
    }

    public static class EstructuraGenerada {
        private List<BlockReference> oldBlocks = new ArrayList<BlockReference>();

        protected static EstructuraGenerada create() {
            return new EstructuraGenerada();
        }

        private EstructuraGenerada() {
        }

        private void add(Block block) {
            this.oldBlocks.add(BlockReference.of(block));
        }

        public void quitar() {
            this.oldBlocks.forEach(BlockReference::colocar);
        }
    }
}

