/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.partida.jugador;

import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.entity.Player;

public class JugadorManager<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>> {
    private final Map<UUID, J> jugadores = new HashMap<UUID, J>();

    public final void add(UUID uuid, J jugador) {
        this.jugadores.computeIfAbsent(uuid, k -> jugador);
    }

    public final Wrapper<J> get(Player player) {
        if (player == null) {
            return Wrapper.empty();
        }
        return this.get(player.getUniqueId());
    }

    public final Wrapper<J> get(UUID uuid) {
        return Wrapper.of((Object)((AbstractJugador)this.jugadores.get(uuid)));
    }

    public final Collection<J> getAll() {
        return this.jugadores.values();
    }

    public final Collection<UUID> getAllUUID() {
        return this.jugadores.keySet();
    }

    public final void ejecutarFuncionTodosLosJugadores(Consumer<J> jugadorConsumer) {
        this.getAll().forEach(jugadorConsumer);
    }

    public final void remove(UUID uuid) {
        this.jugadores.remove(uuid);
    }

    public final void removeAll() {
        this.jugadores.clear();
    }
}

