/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.partida;

import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public class ResetManager {
    private Set<IReseteable> objetosReseteables = new HashSet<IReseteable>();
    private AbstractPartida<?, ?, ?> partida;

    public ResetManager(AbstractPartida<?, ?, ?> partida) {
        this.partida = partida;
    }

    public <T extends IReseteable> T agregarObjeto(T objetoReseteable) {
        if (this.objetosReseteables.contains(objetoReseteable)) {
            throw new DuplicateObjectException();
        }
        this.objetosReseteables.add(objetoReseteable);
        return objetoReseteable;
    }

    public <T extends IReseteable> T agregarSuppplier(Supplier<T> supplier) {
        return (T)this.agregarObjeto((IReseteable)supplier.get());
    }

    public <T extends IReseteable> T agregarFunction(Function<AbstractPartida<?, ?, ?>, T> supplier) {
        return (T)this.agregarObjeto((IReseteable)supplier.apply(this.partida));
    }

    public void reset() {
        ArrayList mantener = new ArrayList();
        this.objetosReseteables.forEach(obj -> {
            if (obj.reset(this.partida)) {
                mantener.add(obj);
            }
        });
        this.objetosReseteables.clear();
        this.objetosReseteables.addAll(mantener);
    }

    public void resetCompleto() {
        this.objetosReseteables.forEach(obj -> obj.resetCompleto(this.partida));
        this.objetosReseteables.clear();
    }

    private class DuplicateObjectException
    extends RuntimeException {
        private static final long serialVersionUID = -3619446883821166537L;

        public DuplicateObjectException() {
            super("The object are duplicate in resetManager");
        }
    }
}

